/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util.jms;

import java.util.HashMap;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;

public class JMSSender {
    
    private QueueSession queueSession = null;
    private HashMap<String, QueueSender> queueSenders = new HashMap<String, QueueSender>();

    public JMSSender(QueueConnection connection) throws JMSException {
        queueSession = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
    }
    
    public void send(Message message, Queue queue, long timeToLive, int deliveryMode) throws JMSException {
        
        // note that as an optimization, we disable the provider generated
        // message id, i.e. because we use wsa message id to uniquely
        // identify the message (set as a jms message property). this may
        // have no affect
        
        QueueSender queueSender = queueSenders.get(queue.getQueueName());
        if (queueSender == null) {
            queueSender = queueSession.createSender(queue);
            queueSender.setDisableMessageID(true);
            queueSenders.put(queue.getQueueName(), queueSender);
        }
        queueSender.send(message, deliveryMode, 4, timeToLive);
        
    }

    public Message createMessage() throws JMSException {
        return queueSession.createMessage();
    }
    
    public TextMessage createTextMessage(String text) throws JMSException {
        return queueSession.createTextMessage(text);
    }

    public void destroy() throws JMSException {
        for (QueueSender sender : queueSenders.values()) {
            sender.close();
        }
        queueSenders.clear();
        queueSession.close();
    }

    @Override
    protected void finalize() throws Throwable {
        destroy();
    }
    
}