/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.http.server.jetty.util;

import java.io.IOException;
import java.security.Principal;

import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPAuthenticationResponse;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.StringUtil;

public class BasicAuthenticatorImpl extends BasicAuthenticator {

    private static final long serialVersionUID = 1L;

    private static final Log log = SystemContext.getContext().getSystem().getLog(BasicAuthenticatorImpl.class);

    /*
     * Copied implementation from super and modified to use HTTPAuthenticationResponse
     * implementation instead of String password.
     * 
     * (non-Javadoc)
     * @see org.mortbay.jetty.security.DigestAuthenticator#authenticate(org.mortbay.jetty.security.UserRealm,
     *      java.lang.String, org.mortbay.jetty.Request, org.mortbay.jetty.Response)
     */
    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {

        Principal user = null;
        String credentials = request.getHeader(HttpHeaders.AUTHORIZATION);

        if (credentials != null) {
            try {

                credentials = credentials.substring(credentials.indexOf(' ') + 1);
                credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
                int i = credentials.indexOf(':');
                String username = credentials.substring(0, i);
                String password = credentials.substring(i + 1);

                if (log.isDebugEnabled()) {
                    log.debug("user: " + username);
                }

                HTTPAuthenticationResponse auth = new HTTPBasicResponse(username, realm.getName(), password);

                user = realm.authenticate(username, auth, request);

                if (user == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("AUTH FAILURE: realm: "
                                + realm.getName()
                                + " user: "
                                + StringUtil.printable(username));
                    }
                } else {
                    request.setAuthType(Constraint.__BASIC_AUTH);
                    request.setUserPrincipal(user);
                }

            } catch (Exception e) {
                log.warn("AUTH FAILURE: " + e.toString());
            }

        }

        if (user == null && response != null) {
            sendChallenge(realm, response);
        }

        return user;

    }

}
