/**
 * Copyright (c) 2004-2005 SLF4J.ORG
 * Copyright (c) 2004-2005 QOS.ch
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute, and/or sell copies of  the Software, and to permit persons
 * to whom  the Software is furnished  to do so, provided  that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the  Software and  that both  the above  copyright notice(s)  and this
 * permission notice appear in supporting documentation.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR  A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF  THIRD PARTY  RIGHTS. IN  NO EVENT  SHALL THE  COPYRIGHT  HOLDER OR
 * HOLDERS  INCLUDED IN  THIS  NOTICE BE  LIABLE  FOR ANY  CLAIM, OR  ANY
 * SPECIAL INDIRECT  OR CONSEQUENTIAL DAMAGES, OR  ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS  OF USE, DATA OR PROFITS, WHETHER  IN AN ACTION OF
 * CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS  ACTION, ARISING OUT OF  OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as  contained in  this notice, the  name of a  copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

package org.slf4j.impl;

import org.bluestemsoftware.specification.eoa.system.System.Log;
import org.bluestemsoftware.specification.eoa.system.SystemContext;

public final class LoggerImpl extends MarkerIgnoringBase {

    private static final Log log = SystemContext.getContext().getSystem().getLog(org.mortbay.jetty.Server.class);
    String name;

    public LoggerImpl(String name) {
      this.name = name;
    }

    public String getName() {
      return name;    
    }
    
    public void debug(String msg) {
        log.debug(msg);
    }

    public void debug(String format, Object arg) {
        log.debug(MessageFormatter.format(format, arg));
    }

    public void debug(String format, Object[] argArray) {
        log.debug(MessageFormatter.arrayFormat(format, argArray));
    }

    public void debug(String msg, Throwable t) {
        log.debug(msg, t);
    }

    public void debug(String format, Object arg1, Object arg2) {
        log.debug(MessageFormatter.format(format, arg1, arg2));
    }

    public void error(String msg) {
        log.error(msg);
    }

    public void error(String format, Object arg) {
        log.error(MessageFormatter.format(format, arg));
    }

    public void error(String format, Object[] argArray) {
        log.error(MessageFormatter.arrayFormat(format, argArray));
    }

    public void error(String msg, Throwable t) {
        log.error(msg, t);
    }

    public void error(String format, Object arg1, Object arg2) {
        log.debug(MessageFormatter.format(format, arg1, arg2));
    }

   public void info(String msg) {
        log.info(msg);
    }

    public void info(String format, Object arg) {
        log.info(MessageFormatter.format(format, arg));
    }

    public void info(String format, Object[] argArray) {
        log.info(MessageFormatter.arrayFormat(format, argArray));
    }

    public void info(String msg, Throwable t) {
        log.info(msg, t);
    }

    public void info(String format, Object arg1, Object arg2) {
        if (format.startsWith("Logging to")) {
            return;
        }
        log.info(MessageFormatter.format(format, arg1, arg2));
    }

    public boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        log.warn(msg);
    }

    public void warn(String format, Object arg) {
        log.warn(MessageFormatter.format(format, arg));
    }

    public void warn(String format, Object[] argArray) {
        log.warn(MessageFormatter.arrayFormat(format, argArray));
    }

    public void warn(String msg, Throwable t) {
        log.warn(msg, t);
    }

    public void warn(String format, Object arg1, Object arg2) {
        log.warn(MessageFormatter.format(format, arg1, arg2));
    }

}
