/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jmx.server.dfault.mgmt.jmx;

import java.io.IOException;

import javax.management.JMException;

/**
 * Management interface exposed via JMX. Note that jmx attribute model is read only, i.e. no
 * attribute setters. just attribute getters and operations
 */

public interface JMXServerMXBean {

    /**
     * Indicates whether or not JMX connection requests are authenticated.
     * 
     * @return
     */
    public boolean isAuthenticationEnabled() throws JMException, IOException;
    
    /**
     * Gets authorized user.
     * 
     * @return user or <code>null</code> if undefined.
     */
    public String getUser() throws JMException, IOException;
    
    /**
     * Gets jaas configuration entry, i.e. app name, used to configure LoginContext
     * for authentication.
     * 
     * @return String jaasConfiguration or the default value 'other' if unspecified.
     */
    public String getJAASConfiguration() throws JMException, IOException;
    
    /**
     * Stops JMX RMI Connector which accepts inbound connections. Once stopped, the
     * connector cannot be restarted without restarting server.
     */
    public void stopConnector() throws JMException, IOException;
    
}
