/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.management.jmx.server.dfault;

import org.bluestemsoftware.specification.eoa.ext.management.ManagementException;
import org.bluestemsoftware.specification.eoa.ext.management.jmx.JMXServerContext;
import org.bluestemsoftware.specification.eoa.ext.management.jmx.JMXServerContextFactory;

public final class JMXServerContextFactoryImpl implements JMXServerContextFactory.Provider {

    public static final String NAME = "jmx-server-default";
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory$Provider#spi_createFeature()
     */
    public JMXServerContext.Provider spi_createManagmentContext() throws ManagementException {
        return new JMXServerContextImpl();
    }

}
