/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.XMLChar;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.aspectj.internal.lang.annotation.ajcITD;
import org.aspectj.runtime.internal.AroundClosure;
import org.bluestemsoftware.open.eoa.aspect.axiom.ContentFactoryImpl;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.STAXUtils;
import org.bluestemsoftware.specification.eoa.component.message.rt.Content;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentFactory;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentSerialization;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.ApplicationData;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DocumentImpl
extends ParentNode
implements Document,
OMDocument,
ContentFactory {
    private String xmlVersion;
    private String charEncoding;
    private Vector idAttrs;
    protected ElementImpl documentElement;
    protected Hashtable identifiers;

    public DocumentImpl(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
        ((OMDOMFactory)factory).setDocument(this);
        this.done = true;
    }

    public DocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.builder = parserWrapper;
        ((OMDOMFactory)factory).setDocument(this);
    }

    public DocumentImpl(OMFactory factory) {
        super(factory);
        ((OMDOMFactory)factory).setDocument(this);
        this.done = true;
    }

    public void setType(int nodeType) throws OMException {
        throw new UnsupportedOperationException("In OM Document object doesn't have a type");
    }

    public int getType() throws OMException {
        throw new UnsupportedOperationException("In OM Document object doesn't have a type");
    }

    public void internalSerialize(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter2 = xMLStreamWriter;
        DocumentImpl.internalSerialize_aroundBody1$advice(this, xMLStreamWriter2, ContentFactoryImpl.aspectOf(), this, xMLStreamWriter2, null);
    }

    public OMNode getNextOMSibling() throws OMException {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public OMContainer getParent() throws OMException {
        throw new UnsupportedOperationException("This is the document node");
    }

    public OMNode getPreviousOMSibling() {
        throw new UnsupportedOperationException("This is the document node");
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void setNextOMSibling(OMNode node) {
        throw new UnsupportedOperationException("This is the document node");
    }

    public void setParent(OMContainer element) {
        throw new UnsupportedOperationException("This is the document node");
    }

    public void setPreviousOMSibling(OMNode node) {
        throw new UnsupportedOperationException("This is the document node");
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public Attr createAttribute(String name) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new AttrImpl(this, name, this.factory);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        if ("xmlns".equals(localName)) {
            return this.createAttribute(localName);
        }
        this.checkQName(prefix, localName);
        return new AttrImpl(this, localName, new NamespaceImpl(namespaceURI, prefix), this.factory);
    }

    public CDATASection createCDATASection(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data, this.factory);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this, this.factory);
    }

    public Element createElement(String tagName) throws DOMException {
        return new ElementImpl(this, tagName, this.factory);
    }

    public Element createElementNS(String ns, String qualifiedName) throws DOMException {
        if (ns == null) {
            ns = "";
        }
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        if (prefix == null) {
            prefix = "";
        }
        if (prefix != null && !"".equals(prefix)) {
            this.checkQName(prefix, localName);
        }
        NamespaceImpl namespace = new NamespaceImpl(ns, prefix);
        return new ElementImpl(this, localName, namespace, this.factory);
    }

    public EntityReference createEntityReference(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public ProcessingInstruction createProcessingInstruction(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public Text createTextNode(String value) {
        return new TextImpl(this, value, this.factory);
    }

    public DocumentType getDoctype() {
        return DocumentImpl.getDoctype_aroundBody3$advice(this, ContentFactoryImpl.aspectOf(), null);
    }

    public Element getElementById(String elementId) {
        if (this.idAttrs == null) {
            return null;
        }
        Enumeration attrEnum = this.idAttrs.elements();
        while (attrEnum.hasMoreElements()) {
            Attr tempAttr = (Attr)attrEnum.nextElement();
            if (!tempAttr.getValue().equals(elementId)) continue;
            return tempAttr.getOwnerElement();
        }
        return null;
    }

    public NodeList getElementsByTagName(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        throw new UnsupportedOperationException("TODO");
    }

    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("TODO");
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        short type = importedNode.getNodeType();
        Node newNode = null;
        switch (type) {
            case 1: {
                Element newElement;
                if (importedNode.getLocalName() == null) {
                    newElement = this.createElement(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newElement = this.createElementNS(ns, importedNode.getNodeName());
                }
                NamedNodeMap sourceAttrs = importedNode.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    for (int index = 0; index < length; ++index) {
                        Attr newAttr;
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                            newAttr = (Attr)this.importNode(attr, true);
                            newElement.setAttributeNodeNS(newAttr);
                            continue;
                        }
                        newAttr = (Attr)this.importNode(attr, true);
                        newElement.setAttributeNode(newAttr);
                    }
                }
                newNode = newElement;
                break;
            }
            case 2: {
                if ("".equals(importedNode.getNamespaceURI()) || importedNode.getNamespaceURI() == null) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else if ("xmlns".equals(importedNode.getNodeName())) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newNode = this.createAttributeNS(ns, importedNode.getNodeName());
                }
                ((Attr)newNode).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                newNode = this.createTextNode(importedNode.getNodeValue());
                break;
            }
            case 8: {
                newNode = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 11: {
                newNode = this.createDocumentFragment();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                throw new UnsupportedOperationException("TODO : Implement handling of org.w3c.dom.Node type == " + type);
            }
            default: {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, msg);
            }
        }
        if (deep && !(importedNode instanceof Attr)) {
            for (Node srckid = importedNode.getFirstChild(); srckid != null; srckid = srckid.getNextSibling()) {
                newNode.appendChild(this.importNode(srckid, true));
            }
        }
        return newNode;
    }

    public void serialize(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter2 = xMLStreamWriter;
        DocumentImpl.serialize_aroundBody5$advice(this, xMLStreamWriter2, ContentFactoryImpl.aspectOf(), this, xMLStreamWriter2, null);
    }

    public void internalSerializeAndConsume(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter2 = xMLStreamWriter;
        DocumentImpl.internalSerializeAndConsume_aroundBody7$advice(this, xMLStreamWriter2, ContentFactoryImpl.aspectOf(), this, xMLStreamWriter2, null);
    }

    public void serializeAndConsume(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter2 = xMLStreamWriter;
        DocumentImpl.serializeAndConsume_aroundBody9$advice(this, xMLStreamWriter2, ContentFactoryImpl.aspectOf(), this, xMLStreamWriter2, null);
    }

    public String getCharsetEncoding() {
        return this.charEncoding;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public String isStandalone() {
        throw new UnsupportedOperationException("TODO");
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charEncoding = charsetEncoding;
    }

    public void setOMDocumentElement(OMElement rootElement) {
        this.firstChild = (ElementImpl)rootElement;
    }

    public void setStandalone(String isStandalone) {
        throw new UnsupportedOperationException("TODO");
    }

    public void serializeAndConsume(OutputStream outputStream, OMOutputFormat oMOutputFormat) throws XMLStreamException {
        OutputStream outputStream2 = outputStream;
        OMOutputFormat oMOutputFormat2 = oMOutputFormat;
        DocumentImpl.serializeAndConsume_aroundBody11$advice(this, outputStream2, oMOutputFormat2, ContentFactoryImpl.aspectOf(), this, outputStream2, oMOutputFormat2, null);
    }

    public void serialize(OutputStream outputStream, OMOutputFormat oMOutputFormat) throws XMLStreamException {
        OutputStream outputStream2 = outputStream;
        OMOutputFormat oMOutputFormat2 = oMOutputFormat;
        DocumentImpl.serialize_aroundBody13$advice(this, outputStream2, oMOutputFormat2, ContentFactoryImpl.aspectOf(), this, outputStream2, oMOutputFormat2, null);
    }

    public void setXMLVersion(String version) {
        this.xmlVersion = version;
    }

    public OMElement getOMDocumentElement() {
        if (this.documentElement == null && !this.done) {
            this.builder.next();
        }
        return this.documentElement;
    }

    public Element getDocumentElement() {
        return (Element)this.getOMDocumentElement();
    }

    protected final void checkQName(String prefix, String local) {
        boolean validNCName;
        boolean bl = validNCName = (prefix == null || XMLChar.isValidNCName(prefix)) && XMLChar.isValidNCName(local);
        if (!validNCName) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        if (prefix == null || prefix.equals("")) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
    }

    public void build() {
        if (this.firstChild != null && !this.firstChild.done) {
            this.firstChild.build();
        }
        this.done = true;
    }

    protected void addIdAttr(Attr attr) {
        if (this.idAttrs == null) {
            this.idAttrs = new Vector();
        }
        this.idAttrs.add(attr);
    }

    protected void removeIdAttr(Attr attr) {
        if (this.idAttrs != null) {
            this.idAttrs.remove(attr);
        }
    }

    public Node adoptNode(Node node) throws DOMException {
        return this.importNode(node, true);
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("TODO");
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("TODO");
    }

    public String getXmlEncoding() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("TODO");
    }

    public String getXmlVersion() {
        throw new UnsupportedOperationException("TODO");
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException("TODO");
    }

    public Node renameNode(Node arg0, String arg1, String arg2) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setDocumentURI(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public void setStrictErrorChecking(boolean arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public void setXmlStandalone(boolean arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setXmlVersion(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public static /* synthetic */ ElementImpl ajc$privFieldGet$org_bluestemsoftware_open_eoa_aspect_axiom_ContentImpl$org_apache_axiom_om_impl_dom_DocumentImpl$documentElement(DocumentImpl documentImpl) {
        return documentImpl.documentElement;
    }

    public static /* synthetic */ void ajc$privFieldSet$org_bluestemsoftware_open_eoa_aspect_axiom_ContentImpl$org_apache_axiom_om_impl_dom_DocumentImpl$documentElement(DocumentImpl documentImpl, ElementImpl elementImpl) {
        documentImpl.documentElement = elementImpl;
    }

    private static final /* synthetic */ void internalSerialize_aroundBody0(DocumentImpl this_, XMLStreamWriter writer) {
    }

    private static final /* synthetic */ void internalSerialize_aroundBody1$advice(DocumentImpl this_, XMLStreamWriter d, ContentFactoryImpl writer, DocumentImpl ajc_aroundClosure, XMLStreamWriter xMLStreamWriter, AroundClosure aroundClosure) {
        STAXUtils.serializeDocument(ajc_aroundClosure, xMLStreamWriter, true);
    }

    private static final /* synthetic */ DocumentType getDoctype_aroundBody2(DocumentImpl this_) {
        throw new UnsupportedOperationException("TODO");
    }

    private static final /* synthetic */ DocumentType getDoctype_aroundBody3$advice(DocumentImpl this_, ContentFactoryImpl ajc_aroundClosure, AroundClosure aroundClosure) {
        return null;
    }

    private static final /* synthetic */ void serialize_aroundBody4(DocumentImpl this_, XMLStreamWriter xmlWriter) {
        throw new UnsupportedOperationException("TODO");
    }

    private static final /* synthetic */ void serialize_aroundBody5$advice(DocumentImpl this_, XMLStreamWriter d, ContentFactoryImpl writer, DocumentImpl ajc_aroundClosure, XMLStreamWriter xMLStreamWriter, AroundClosure aroundClosure) {
        STAXUtils.serializeDocument(ajc_aroundClosure, (XMLStreamWriter)new MTOMXMLStreamWriter(xMLStreamWriter), true);
    }

    private static final /* synthetic */ void internalSerializeAndConsume_aroundBody6(DocumentImpl this_, XMLStreamWriter writer) {
        throw new UnsupportedOperationException("TODO");
    }

    private static final /* synthetic */ void internalSerializeAndConsume_aroundBody7$advice(DocumentImpl this_, XMLStreamWriter d, ContentFactoryImpl writer, DocumentImpl ajc_aroundClosure, XMLStreamWriter xMLStreamWriter, AroundClosure aroundClosure) {
        STAXUtils.serializeDocument(ajc_aroundClosure, xMLStreamWriter, false);
    }

    private static final /* synthetic */ void serializeAndConsume_aroundBody8(DocumentImpl this_, XMLStreamWriter xmlWriter) {
        throw new UnsupportedOperationException("TODO");
    }

    private static final /* synthetic */ void serializeAndConsume_aroundBody9$advice(DocumentImpl this_, XMLStreamWriter d, ContentFactoryImpl writer, DocumentImpl ajc_aroundClosure, XMLStreamWriter xMLStreamWriter, AroundClosure aroundClosure) {
        STAXUtils.serializeDocument(ajc_aroundClosure, (XMLStreamWriter)new MTOMXMLStreamWriter(xMLStreamWriter), false);
    }

    private static final /* synthetic */ void serializeAndConsume_aroundBody10(DocumentImpl this_, OutputStream output, OMOutputFormat format) {
        throw new UnsupportedOperationException("TODO");
    }

    private static final /* synthetic */ void serializeAndConsume_aroundBody11$advice(DocumentImpl this_, OutputStream d, OMOutputFormat out, ContentFactoryImpl format, DocumentImpl ajc_aroundClosure, OutputStream outputStream, OMOutputFormat oMOutputFormat, AroundClosure aroundClosure) {
        STAXUtils.serializeDocument(ajc_aroundClosure, (XMLStreamWriter)new MTOMXMLStreamWriter(outputStream, oMOutputFormat), false);
    }

    private static final /* synthetic */ void serialize_aroundBody12(DocumentImpl this_, OutputStream output, OMOutputFormat format) {
        throw new UnsupportedOperationException("TODO");
    }

    private static final /* synthetic */ void serialize_aroundBody13$advice(DocumentImpl this_, OutputStream d, OMOutputFormat out, ContentFactoryImpl format, DocumentImpl ajc_aroundClosure, OutputStream outputStream, OMOutputFormat oMOutputFormat, AroundClosure aroundClosure) {
        STAXUtils.serializeDocument(ajc_aroundClosure, (XMLStreamWriter)new MTOMXMLStreamWriter(outputStream, oMOutputFormat), true);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="createApplicationData", modifiers=1)
    public ApplicationData createApplicationData(String string, String string2) {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$createApplicationData(this, string, string2);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="createContent", modifiers=1)
    public Content createContent(String string, String string2) {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$createContent(this, string, string2);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="importContent", modifiers=1)
    public Content importContent(Content content) {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$importContent(this, content);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="parseContent", modifiers=1)
    public Content parseContent(InputStream inputStream) throws SAXException, IOException {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$parseContent(this, inputStream);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="parseContent", modifiers=1)
    public Content parseContent(InputStream inputStream, ContentSerialization contentSerialization) throws SAXException, IOException {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$parseContent(this, inputStream, contentSerialization);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="parseContent", modifiers=1)
    public Content parseContent(InputStream inputStream, ContentSerialization contentSerialization, String string) throws SAXException, IOException {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$parseContent(this, inputStream, contentSerialization, string);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="parseContent", modifiers=1)
    public Content parseContent(String string) throws SAXException, IOException {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$parseContent(this, string);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="parseContent", modifiers=1)
    public Content parseContent(String string, ContentSerialization contentSerialization) throws SAXException, IOException {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$parseContent(this, string, contentSerialization);
    }

    @ajcITD(targetType="org.apache.axiom.om.impl.dom.DocumentImpl", name="parseContent", modifiers=1)
    public Content parseContent(String string, ContentSerialization contentSerialization, String string2) throws SAXException, IOException {
        return ContentFactoryImpl.ajc$interMethod$org_bluestemsoftware_open_eoa_aspect_axiom_ContentFactoryImpl$org_apache_axiom_om_impl_dom_DocumentImpl$parseContent(this, string, contentSerialization, string2);
    }
}

