/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.aspect.axiom.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.bluestemsoftware.open.eoa.aspect.axiom.DocumentElement;
import org.bluestemsoftware.open.eoa.aspect.axiom.ParsedContent;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.ContentBuilder;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.ContextInfo;
import org.bluestemsoftware.specification.eoa.component.message.rt.Content;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentSerialization;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentSerializationXML;
import org.bluestemsoftware.specification.eoa.ext.message.ContentSerializationBadgerJSON;
import org.bluestemsoftware.specification.eoa.ext.message.ContentSerializationJSON;
import org.bluestemsoftware.specification.eoa.ext.message.ContentSerializationMappedJSON;
import org.codehaus.jettison.badgerfish.BadgerFishXMLInputFactory;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class STAXUtils {
    private static ContentSerialization XML = ContentSerializationXML.getInstance();
    private static ContentSerialization JSON = ContentSerializationMappedJSON.getInstance();
    private static ContentSerialization FISH = ContentSerializationBadgerJSON.getInstance();
    private static final String XML_INPUT_CLASS = "com.ctc.wstx.stax.WstxInputFactory";
    private static final String XML_OUTPUT_CLASS = "com.ctc.wstx.stax.WstxOutputFactory";
    private static final String EOF_EXCEPTION = "com.ctc.wstx.exc.WstxEOFException";
    private static Map<ContentSerialization, XMLInputFactory> inputFactories = new HashMap<ContentSerialization, XMLInputFactory>();
    private static Map<ContentSerialization, XMLOutputFactory> outputFactories = new HashMap<ContentSerialization, XMLOutputFactory>();

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return STAXUtils.createXMLStreamReader(XML, in, encoding);
    }

    public static XMLStreamReader createXMLStreamReader(ContentSerialization ser, InputStream in, String encoding) throws XMLStreamException {
        return STAXUtils.getXMLInputFactory(ser).createXMLStreamReader(in, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) throws XMLStreamException {
        return STAXUtils.createXMLStreamWriter(XML, out, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(ContentSerialization ser, OutputStream out, String encoding) throws XMLStreamException {
        return STAXUtils.getXMLOutputFactory(ser).createXMLStreamWriter(out, encoding);
    }

    public static ContextInfo adjustContext(Content content) {
        Node pa = content.getParentNode();
        if (pa != null) {
            ((OMNode)pa).build();
        }
        Node ns = content.getNextSibling();
        Document ownerDocument = content.getOwnerDocument();
        Element documentElement = ownerDocument.getDocumentElement();
        ContextInfo contextInfo = new ContextInfo(documentElement, pa, ns);
        if (documentElement != null) {
            ((DocumentElement)((Object)documentElement)).detachFromDocument();
        }
        if (content.getParentNode() != null) {
            ((OMElement)content).detach();
        }
        ((DocumentElement)content).attachToDocument();
        return contextInfo;
    }

    public static void restoreContext(ContextInfo contextInfo, Content content) {
        Node partAccessor;
        ((DocumentElement)content).detachFromDocument();
        Element documentElement = contextInfo.getDocumentElement();
        if (documentElement != null) {
            ((DocumentElement)((Object)documentElement)).attachToDocument();
        }
        if ((partAccessor = contextInfo.getPartAccessor()) != null) {
            partAccessor.insertBefore((Node)content, contextInfo.getNextSibling());
        }
    }

    public static Content parseContent(OMDOMFactory factory, InputStream inputStream, ContentSerialization serialization, String encoding) throws SAXException, IOException {
        if (serialization instanceof ContentSerializationXML) {
            try {
                InputSource is = new InputSource(inputStream);
                is.setEncoding(encoding);
                XMLStreamReader parser = STAXUtils.getXMLInputFactory(serialization).createXMLStreamReader(new SAXSource(is));
                OMDOMFactory newFactory = (OMDOMFactory)factory.getClass().newInstance();
                ContentBuilder builder = new ContentBuilder(newFactory, parser);
                DocumentElement documentElement = (DocumentElement)builder.getDocumentElement();
                documentElement.detachFromDocument();
                return ((ParsedContent)((Object)documentElement)).setOwnerDocument(factory.getDocument());
            }
            catch (Throwable th) {
                Throwable cause = th.getCause();
                if (cause != null && cause.getClass().getName().equals(EOF_EXCEPTION)) {
                    return null;
                }
                throw new IOException("Error reading message. " + th.getMessage());
            }
        }
        if (serialization instanceof ContentSerializationJSON) {
            try {
                XMLStreamReader parser = STAXUtils.getXMLInputFactory(serialization).createXMLStreamReader(inputStream, encoding);
                OMDOMFactory newFactory = (OMDOMFactory)factory.getClass().newInstance();
                ContentBuilder builder = new ContentBuilder(newFactory, parser);
                DocumentElement documentElement = (DocumentElement)builder.getDocumentElement();
                documentElement.detachFromDocument();
                return ((ParsedContent)((Object)documentElement)).setOwnerDocument(factory.getDocument());
            }
            catch (Throwable th) {
                throw new IOException("Error reading message. " + th.getMessage());
            }
        }
        throw new IllegalArgumentException("Error serializing content. Unsupported serialization '" + serialization + "'.");
    }

    /*
     * Loose catch block
     */
    public static String serializeContent(OMElement omElement, ContentSerialization serialization, String encoding) {
        if (serialization instanceof ContentSerializationXML) {
            return omElement.toString();
        }
        if (serialization instanceof ContentSerializationJSON) {
            ContextInfo contextInfo = null;
            try {
                String string;
                block8: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLStreamWriter writer = STAXUtils.getXMLOutputFactory(serialization).createXMLStreamWriter(baos, encoding);
                    contextInfo = STAXUtils.adjustContext((Content)omElement);
                    writer = new MTOMXMLStreamWriter(writer);
                    STAXUtils.serializeDocument((DocumentImpl)omElement.getParent(), writer, true);
                    string = baos.toString(encoding);
                    if (contextInfo == null) break block8;
                    STAXUtils.restoreContext(contextInfo, (Content)omElement);
                }
                return string;
            }
            catch (Throwable th) {
                throw new IllegalStateException("Error writing message. " + th.getMessage());
                {
                    catch (Throwable throwable) {
                        if (contextInfo != null) {
                            STAXUtils.restoreContext(contextInfo, (Content)omElement);
                        }
                        throw throwable;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Error serializing content. Unsupported serialization '" + serialization + "'.");
    }

    private static synchronized XMLInputFactory getXMLInputFactory(ContentSerialization ser) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = inputFactories.get(ser);
        if (xmlInputFactory == null) {
            if (ser.equals(XML)) {
                Class<?> temp;
                try {
                    temp = Thread.currentThread().getContextClassLoader().loadClass(XML_INPUT_CLASS);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException("Deployment classloader must scope factory class com.ctc.wstx.stax.WstxInputFactory to deployment classpath");
                }
                try {
                    xmlInputFactory = (XMLInputFactory)temp.newInstance();
                }
                catch (Exception ex) {
                    throw new XMLStreamException("Error instantiating parser factory. " + ex);
                }
                xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
                xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            } else if (ser.equals(JSON)) {
                Configuration configuration = new Configuration();
                configuration.setIgnoreNamespaces(true);
                xmlInputFactory = new MappedXMLInputFactory(configuration);
            } else if (ser.equals(FISH)) {
                xmlInputFactory = new BadgerFishXMLInputFactory();
            } else {
                throw new IllegalArgumentException("Error parsing content. Unsupported serialization '" + ser + "'.");
            }
            inputFactories.put(ser, xmlInputFactory);
        }
        return xmlInputFactory;
    }

    private static synchronized XMLOutputFactory getXMLOutputFactory(ContentSerialization ser) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = outputFactories.get(ser);
        if (xmlOutputFactory == null) {
            if (ser.equals(XML)) {
                Class<?> temp;
                try {
                    temp = Thread.currentThread().getContextClassLoader().loadClass(XML_OUTPUT_CLASS);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException("Deployment classloader must scope factory class com.ctc.wstx.stax.WstxOutputFactory to deployment classpath");
                }
                try {
                    xmlOutputFactory = (XMLOutputFactory)temp.newInstance();
                }
                catch (Exception ex) {
                    throw new XMLStreamException("Error instantiating parser factory. " + ex);
                }
            }
            if (ser.equals(JSON)) {
                Configuration configuration = new Configuration();
                configuration.setIgnoreNamespaces(true);
                xmlOutputFactory = new MappedXMLOutputFactory(configuration);
            } else if (ser.equals(FISH)) {
                xmlOutputFactory = new BadgerFishXMLOutputFactory();
            } else {
                throw new IllegalArgumentException("Error serializing content. Unsupported serialization '" + ser + "'.");
            }
            outputFactories.put(ser, xmlOutputFactory);
        }
        return xmlOutputFactory;
    }

    public static void serializeDocument(DocumentImpl document, XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter temp = (MTOMXMLStreamWriter)writer;
        if (!temp.isIgnoreXMLDeclaration()) {
            String charSetEncoding = document.getCharsetEncoding() == null ? "UTF-8" : document.getCharsetEncoding();
            String xmlVersion = document.getXMLVersion() == null ? "1.0" : document.getXMLVersion();
            String outputCharEncoding = temp.getCharSetEncoding();
            if (outputCharEncoding == null || outputCharEncoding.equals("")) {
                temp.getXmlStreamWriter().writeStartDocument(charSetEncoding, xmlVersion);
            } else {
                temp.getXmlStreamWriter().writeStartDocument(outputCharEncoding, xmlVersion);
            }
        }
        Iterator children = document.getChildren();
        while (children.hasNext()) {
            OMNodeEx omNode = (OMNodeEx)children.next();
            if (cache) {
                omNode.internalSerialize((XMLStreamWriter)temp);
                continue;
            }
            omNode.internalSerializeAndConsume((XMLStreamWriter)temp);
        }
        temp.getXmlStreamWriter().writeEndDocument();
        temp.flush();
    }
}

