/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
 
package org.bluestemsoftware.open.eoa.aspect.axiom;

import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.XMLStreamConstants;

import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.bluestemsoftware.specification.eoa.component.message.rt.Content;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentFactory;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentSerialization;
import org.bluestemsoftware.specification.eoa.component.message.rt.ContentSerializationXML;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPVersion;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.STAXUtils;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.ContentBuilder;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.ApplicationData;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.WSAD.WSAD10.Infoset;

import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.ChildNode;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.DocumentImpl;

public privileged aspect ContentImpl {
    
    declare parents : ElementImpl implements Content, DocumentElement, ParsedContent, PartAccessor, ApplicationData;

    public XMLStreamReader ElementImpl.getReader() {
        
        // note that users of this method have to understand context within which
        // element exists when retrieving parser, i.e. if this element is not root
        // node, the parser is shared by other nodes within tree, and an error
        // will occur if other nodes attempt to build, i.e. because parser has
        // been accessed (assuming we do not return null)
        
        try {
            return this.getXMLStreamReaderWithoutCaching();
        } catch (UnsupportedOperationException ex) {
            if (this.builder == null) {
                throw new UnsupportedOperationException("XMLStreamReader is unavailable. Content" +
                        " was built-up, i.e. it was not sourced from an xml stream.");
            } else {
                throw new UnsupportedOperationException("XMLStreamReader is unavailable. Underlying" +
                        " reader was consumed.");
            }
        }
        
    }
    
    public void ElementImpl.serializeAndConsume(XMLStreamWriter xmlWriter, OMOutputFormat omOutputFormat) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(xmlWriter);
        writer.setOutputFormat(omOutputFormat);
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }
    
    public ContentFactory ElementImpl.getFactory() {
        return (ContentFactory)this.getOwnerDocument();
    }
    
    /*
     * As of version 1.2.5 snapshot, detach does not set siblings to null
     * on detached node - bug?
     */
    OMNode around(ChildNode c):
    target(c) && execution(OMNode ChildNode.detach()) {
        proceed(c);
        c.previousSibling = null;
        c.nextSibling = null;
        return c;
    }
    
    /*
     * axiom NodeImpl throws unsupported operation exception as of version 1.2.5
     * snapshot
     */
    String around(ElementImpl e, String prefix):
        execution(String NodeImpl.lookupNamespaceURI(String)) && args(prefix) && this(e) {
            OMNamespace ns = e.findNamespaceURI(prefix);
            if (ns != null) {
                return ns.getNamespaceURI();
            } else {
                return null;
            }
        }   
    
    /*
     * see comments on interface
     */
    public Content ElementImpl.detachFromDocument() {
        this.parentNode.firstChild = null;
        this.parentNode.lastChild = null;
        this.parentNode.builder = null;
        this.parentNode.done = true;
        ((DocumentImpl)this.parentNode).documentElement = null;
        this.parentNode = null;
        return this;
    }
    
    /*
     * see comments on interface
     */
    public Content ElementImpl.setOwnerDocument(Document document) {
        this.ownerNode = (DocumentImpl)document;
        return this;
    }
    
    /*
     * see comments on interface
     */
    public Content ElementImpl.setOwnerDocument(OMDocument document) {
        this.ownerNode = (DocumentImpl)document;
        ((ContentBuilder)this.builder).setOMDocument(document);
        this.factory = ((OMDocument)document).getOMFactory();
        ((StAXBuilder)this.builder).setOMBuilderFactory(this.factory);
        return this;
    }
    
    /*
     * see comments on interface
     */
    public void ElementImpl.attachToDocument() {
        this.parentNode = this.ownerNode;
        this.parentNode.firstChild = this;
        this.parentNode.lastChild = this;
        ((DocumentImpl)this.parentNode).documentElement = this;
    }
    
    public void ElementImpl.discardContent() {
        
        OMElement content = this.getFirstElement();
        
        if (content == null) {
            return;
        }
        
        if (content.isComplete()){
            
            if(this.builder != null && !this.builder.isCompleted()) {
                this.builder.next();
            }
            
            // TODO: remove code above once axiom bug fixed. as of version 1.2.5
            // snapshot, if content is complete and content was streamed, builder
            // keeps reference to discarded node, i.e. as the 'lastNode'. we must
            // therefore advance the parser one step to remove the reference. else
            // builder will use it to retrieve/ parent node when building next
            // sibling, e.g. a text node -> NPE
            
            content.detach();
            
        } else {
            
            // content.discard();

            // TODO: uncomment code above and remove code below once
            // axiom bug is fixed. as of version 1.2.5 snapshot, the
            // discard method throws an NPE. we shouldn't have to
            // build the node to memory just to discard it !!
            
            // Note had to comment out code below because we cannot
            // weave StAXBuilder -> it's defined within the axiom
            // api artifact, which also means we don't have priveleged
            // access to fields on builder. so ... we must build the
            // content to memory. yuk !!!!
            // 
            // int event =0;
            // String localName = content.getLocalName();
            // XMLStreamReader elementParser = content.getXMLStreamReaderWithoutCaching();
            // do{
            //    try {
            //        event = elementParser.next();
            //    } catch (XMLStreamException xe) {
            //        throw new RuntimeException(xe);
            //    }
            // } while(!(event == XMLStreamConstants.END_ELEMENT && localName.equals(elementParser.getLocalName())));
            
            // ((ModifiableBuilder)((ElementImpl)content).builder).setParserAccessed(false);
            // ((StAXBuilder)((ElementImpl)content).builder).setCache(true);
            // ((ElementImpl)((ElementImpl)content)).builder = null;
            // ((ElementImpl)content).done = true;
            
            this.build();
            content.detach();
                        
        }  
        
    }
    
    public String ElementImpl.toXML() {
        return STAXUtils.serializeContent(this, (ContentSerialization)ContentSerializationXML.getInstance(), "UTF-8");
    }
    
    public String ElementImpl.serializeContent(ContentSerialization serialization) {
        return STAXUtils.serializeContent(this, serialization, "UTF-8");
    }
    
    public String ElementImpl.serializeContent(ContentSerialization serialization, String encoding) {
        return STAXUtils.serializeContent(this, serialization, encoding);
    }
    
    /*
     * Overrides toString method on ElementImpl. as of version 1.2.3, woodstox
     * throws an IOException sometimes. I debugged down into sun's UTF8 reader
     * and it appears to occur at EOF of stream ... Not sure what's causing it,
     * but this fixes it.
     */
    String around(ElementImpl e):
        execution(String ElementImpl.toString()) && this(e) {
            ByteArrayOutputStream baos = null;
            try {
                baos = new ByteArrayOutputStream();
                e.serialize(baos);
            } catch (Exception ex) {
                e.build();
                baos = new ByteArrayOutputStream();
                try {
                    e.serialize(baos);
                } catch (Exception exx) {
                    return super.toString();
                }
            }
            String answer = null;
            try {
                answer = new String(baos.toByteArray(), "UTF-8");
            } catch (Exception fatchance) {
            }
            return answer;
        }   
    
    /*
     * ApplicationData method
     */
    public String ElementImpl.getRole() {
        return this.getAttributeValue(Infoset.ROLE_ATT);
    }

    /*
     * ApplicationData method
     */
    public void ElementImpl.setRole(String role) {
        QName qname = Infoset.ROLE_ATT;
        if (role == null) {
            OMAttribute attrib = this.getAttribute(qname);
            if (attrib != null) {
                this.removeAttribute(attrib);
            }
        }
        OMFactory factory = this.getOMFactory();
        OMNamespace ns = factory.createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
        this.addAttribute(qname.getLocalPart(), role, ns);
    }

    /*
     * ApplicationData method
     */
    public void ElementImpl.setMustUnderstand(boolean mustUnderstand) {
        OMFactory factory = this.getOMFactory();
        QName qname = Infoset.MUST_UNDERSTAND_ATT;
        OMNamespace ns = factory.createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
        this.addAttribute(qname.getLocalPart(), Boolean.toString(mustUnderstand), ns);
    }

    /*
     * ApplicationData method
     */
    public boolean ElementImpl.mustUnderstand() {
        String temp = this.getAttributeValue(Infoset.MUST_UNDERSTAND_ATT);
        if (temp == null) {
            return false;
        }
        return Boolean.parseBoolean(temp);
    }

}
