/**
 * Copyright  2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.aspect.axiom;

import org.bluestemsoftware.specification.eoa.component.message.rt.Content;

public interface DocumentElement {

    /**
     * Allows us to detach document element from document without invoking detach which
     * would force a cached build of the entire message to memory.
     * 
     * @return detached content
     */
    public Content detachFromDocument();
    
    /**
     * Converts this element into document element, i.e. set as document element of owner
     * document.  Facilitates context switching in preparation for xpath evaluation.
     */
    public void attachToDocument();

}
