/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.application.spring10;

import java.util.Map;

import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.component.application.rt.AbstractApplicationReference;
import org.bluestemsoftware.specification.eoa.component.application.rt.AbstractRoleReference;
import org.bluestemsoftware.specification.eoa.component.application.rt.RoleReference;

public class SpringApplicationReference extends AbstractApplicationReference {

    public SpringApplicationReference(ComponentName applicationName, Map<String, RoleReference> roleReferences,
            boolean isMyApplication) {
        super(applicationName, roleReferences, isMyApplication);
    }
    
    @Override
    protected AbstractRoleReference createRoleReference(String roleName) throws DeploymentException {
        if (isMyApplication) {
            throw new DeploymentException("Cannot auto-generate missing role reference"
                    + " which references 'my' role " + roleName + ". Definitions for instances"
                    + " of SpringApplication require that a RoleReference be defined for each Role"
                    + " defined on Application with name of 'bean' that implements runtime behavior."
                    + " See schema.");
        } else {
            return new SpringRoleReference(roleName, null, null);
        }
    }
    
}
