/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.application.spring10;

import java.util.Map;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.component.application.rt.AbstractApplicationRT;
import org.bluestemsoftware.specification.eoa.component.application.rt.AbstractApplicationReference;
import org.bluestemsoftware.specification.eoa.component.application.rt.ApplicationRT;
import org.bluestemsoftware.specification.eoa.component.application.rt.ApplicationReference;
import org.bluestemsoftware.specification.eoa.ext.application.ApplicationFactory;

/**
 * An implementation that uses the 'Spring Application Framework' to 'wire' together a runtime
 * <code>Application</code> instance, i.e. an instance of {@link SpringEngine}.
 */
public final class SpringApplication extends AbstractApplicationRT {

    public static final String TYPE = "http://bluestemsoftware.org/open/eoa/ext/application/spring/1.0";
    public static final String PROVIDER_SCHEMA_LOCATION = "classpath:///schema/http.bluestemsoftware.org.open.eoa.ext.application.spring.1.0.xsd";

    public SpringApplication(ApplicationFactory factory, ApplicationRT.Provider provider, ComponentName componentName,
            Map<QName, ApplicationReference> applicationReferences) {
        super(factory, provider, componentName, applicationReferences);
    }
    
    @Override
    protected void establishReferences() throws DeploymentException {
        generateImpliedStructure();
        super.establishReferences();
    }
    
    @Override
    protected AbstractApplicationReference createMyApplicationReference() throws DeploymentException {
        throw new DeploymentException("Cannot auto-generate missing application reference"
                + " which references 'my' application " + componentName + ". Definitions for instances"
                + " of SpringApplication require that a RoleReference be defined for each Role"
                + " defined on Application with name of 'bean' that implements runtime behavior."
                + " See schema.");
    }

}
