/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.application.spring10;

import org.bluestemsoftware.specification.eoa.application.spring.AbstractRole;
import org.bluestemsoftware.specification.eoa.component.application.rt.AbstractRoleReference;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ElementPolicy;

public final class SpringRoleReference extends AbstractRoleReference implements AbstractRole {

    private String beanType;

    public SpringRoleReference(String roleName, ElementPolicy elementPolicy, String beanType) {
        super(roleName, elementPolicy);
        this.beanType = beanType; // can be null if auto-gen'd partner role reference
    }

    /*
     * 
     */
    public String getBeanType() {
        return beanType;
    }

}
