/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.engine.spring10.util;

import org.bluestemsoftware.open.eoa.engine.spring.SpringEngine;
import org.bluestemsoftware.specification.eoa.application.spring.MyApplication;
import org.bluestemsoftware.specification.eoa.application.spring.MyApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import javax.servlet.ServletContext;

/**
 * Extends spring's <code>ContextLoader</code> such that we can override behavior which
 * locates shared root application context, i.e. which is set as parent of all web application contexts.
 */
public class ContextLoaderImpl extends ContextLoader {

    /*
     * (non-Javadoc)
     * @see org.springframework.web.context.ContextLoader#loadParentContext(javax.servlet.ServletContext)
     */
    @Override
    protected ApplicationContext loadParentContext(ServletContext servletContext) {
        MyApplication myApplication = MyApplicationContext.getApplication();
        return ((SpringEngine)myApplication).getApplicationContext();
    }

}
