/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.engine.spring10.impl;

import org.bluestemsoftware.open.eoa.engine.spring.SpringEngineConfiguration;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngineFactory;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngine.Provider;

public class SpringEngineFactoryImpl implements SpringEngineFactory.Provider {

    private static final long serialVersionUID = 1L;
    
    public static final String NAME = "spring-10-engine";

    public SpringEngineFactoryImpl() {        
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.engine.spring10.SpringEngineFactory$Provider#spi_createEngine(org.bluestemsoftware.specification.eoa.ext.engine.spring10.SpringEngineConfiguration)
     */
    public Provider spi_createEngine(SpringEngineConfiguration springEngineConfiguration) {
        return new SpringEngineImpl(springEngineConfiguration);
    }
    
    
}
