/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.engine.spring10.util;

import org.springframework.web.context.ContextLoader;

/**
 * Extends spring's <code>ContextLoaderListener</code> such that we can create/delegate to
 * our <code>ContextLoader</code> implementation. Listener is identified by class name within
 * web.xml.
 */
public final class ContextLoaderListener extends org.springframework.web.context.ContextLoaderListener {
    
    /*
     * (non-Javadoc)
     * @see org.springframework.web.context.ContextLoaderListener#createContextLoader()
     */
    @Override
    protected ContextLoader createContextLoader() {
        return new ContextLoaderImpl();
    }

}
