/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.container.standalone10;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

import org.bluestemsoftware.specification.eoa.DeploymentClassLoader;
import org.bluestemsoftware.specification.eoa.system.container.ConnectionSupport;

public class ConnectionSupportImpl implements ConnectionSupport, javax.resource.spi.ConnectionManager {
    private static final long serialVersionUID = 1L;

    private ConnectionManager delegate;
    private DeploymentClassLoader factoryLoader;

    public ConnectionSupportImpl(DeploymentClassLoader factoryLoader, ConnectionManager delegate) {
        this.delegate = delegate;
        this.factoryLoader = factoryLoader;
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryLoader);
            return delegate.allocateConnection(managedConnectionFactory, connectionRequestInfo);
        } finally {
            thread.setContextClassLoader(cl);
        }        
    }

}
