/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.container.standalone10;

import java.io.File;

import org.bluestemsoftware.specification.eoa.ext.container.standalone10.StandaloneContainerConfiguration;
import org.bluestemsoftware.specification.eoa.ext.container.standalone10.StandaloneContainerException;
import org.bluestemsoftware.specification.eoa.ext.container.standalone10.StandaloneContainerFactory;
import org.bluestemsoftware.specification.eoa.system.container.Container;


public final class StandaloneContainerFactoryImpl implements StandaloneContainerFactory.Provider {

    private static final long serialVersionUID = 1L;
    
    public static final String NAME = "standalone-container";

    public StandaloneContainerFactoryImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }


    public Container spi_createContainer(StandaloneContainerFactory factory, StandaloneContainerConfiguration config, File extensionEtcDir, File extensionVarDir) throws StandaloneContainerException {
        return new StandaloneContainerImpl(factory, config, extensionEtcDir, extensionVarDir);
    }

}
