/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.server.standalone10;

import java.io.File;
import java.util.Map;

import org.bluestemsoftware.specification.eoa.ext.server.standalone10.StandaloneServerException;
import org.bluestemsoftware.specification.eoa.ext.server.standalone10.StandaloneServerFactory;
import org.bluestemsoftware.specification.eoa.system.server.Server;
import org.bluestemsoftware.specification.eoa.system.server.EnabledFeature;


public final class StandaloneServerFactoryImpl implements StandaloneServerFactory.Provider {

    private static final long serialVersionUID = 1L;
    
    public static final String NAME = "standalone-server";

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    public Server spi_createServer(StandaloneServerFactory factory, Map<String, EnabledFeature> enabledFeatures, File extensionEtcDir, File extensionVarDir) throws StandaloneServerException {
        return new StandaloneServerImpl(factory, enabledFeatures, extensionEtcDir, extensionVarDir);
    }

}
