/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.addressing.soap.util;

import java.net.URISyntaxException;

import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.binding.Binding;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.service.Endpoint;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.addressing.WSAFeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.TransportProtocol;

public class AddressUtil {

    public static String generateCallbackAddress(EndpointReference endpointReference) throws WSAFeatureException {

        String addressPath = null;
        try {
            addressPath = EndpointReference.generateReplyToAddressPath(endpointReference);
        } catch (URISyntaxException ue) {
            throw new WSAFeatureException("Error generating callback address. " + ue);
        }

        Class<? extends TransportProtocol> clazz = null;
        Endpoint endpoint = endpointReference.getEndpoint();
        Binding binding = endpoint.getBindingReference().getReferencedComponent();
        Class<?> target = binding.getUnderlyingProtocol().getClass();
        while (target != null && clazz == null) {
            clazz = getTransportProtocol(target);
            target = target.getSuperclass();
        }
        if (clazz == null) {
            throw new WSAFeatureException("UnderlyingProtocol class "
                    + binding.getUnderlyingProtocol().getClass().getName()
                    + " defined on Binding "
                    + binding.getName()
                    + " MUST implement "
                    + TransportProtocol.class.getName());
        }
        TransportProtocol tp = clazz.cast(binding.getUnderlyingProtocol());
        try {
            return tp.createEndpointAddress(addressPath, null, null);
        } catch (DeploymentException de) {
            throw new WSAFeatureException("Error generating callback address. " + de.getMessage());
        }

    }

    private static Class<? extends TransportProtocol> getTransportProtocol(Class<?> target) {
        for (Class<?> intrface : target.getInterfaces()) {
            if (TransportProtocol.class.isAssignableFrom(intrface)) {
                return intrface.asSubclass(TransportProtocol.class);
            }
        }
        return null;
    }

}
