/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.ad.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import org.bluestemsoftware.open.eoa.ext.feature.ws.ad.soap.util.WSADPolicyUtil;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule.WSSpecification;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy;
import org.bluestemsoftware.specification.eoa.component.policy.rt.EffectivePolicy;
import org.bluestemsoftware.specification.eoa.component.policy.rt.UnsupportedPolicyException;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.ApplicationDataFeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.WSAD;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.WSAD.WSAD10;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.soap.ApplicationDataBindingModule;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.soap.ApplicationDataFeature;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;

public final class WSADFeatureImpl implements ApplicationDataFeature.Provider {

    public static final String IMPL = WSADFeatureImpl.class.getName();

    private static final long serialVersionUID = 1L;

    private static final Log log = SystemContext.getContext().getSystem().getLog(ApplicationDataFeature.class);

    public WSADFeatureImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getFeatureImpl()
     */
    public String spi_getFeatureImpl() {
        return IMPL;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_init(org.w3c.dom.Element)
     */
    public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {
        log.debug("init begin");
        log.debug("init end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_destroy()
     */
    public void spi_destroy() {
        log.debug("destroy begin");
        log.debug("destroy end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.TransportFeature$Provider#spi_destroyFeatureModule(org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule)
     */
    public void spi_destroyFeatureModule(FeatureModule featureModule) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getConnectorRefs()
     */
    @SuppressWarnings("unchecked")
    public Set<String> spi_getConnectorRefs() {
        return Collections.EMPTY_SET;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_createBindingModule(org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference,
     *      org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy,
     *      org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy)
     */
    public ApplicationDataBindingModule.Provider spi_createBindingModule(EndpointActionReference endpointActionReference, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws FeatureException, UnsupportedPolicyException {

        // currently we do not support public policy. not sure that it would
        // make sense to advertise the feature given that the sending eoa node
        // would do nothing different, i.e. role and must understand are set
        // by user at runtime when sending action, and ... private policy
        // controls receiving node behavior

        if (publicPolicy.getMessagePolicy() != null) {
            throw new ApplicationDataFeatureException("Public policy not supported");
        }
        if (publicPolicy.getOperationPolicy() != null) {
            throw new ApplicationDataFeatureException("Public policy not supported");
        }
        if (publicPolicy.getEndpointPolicy() != null) {
            throw new ApplicationDataFeatureException("Public policy not supported");
        }
        if (publicPolicy.getServicePolicy() != null) {
            throw new ApplicationDataFeatureException("Public policy not supported");
        }
        
        // the goal is to create one instance of ws-ad spec for each supported version
        // of wsad specification implied by policy. currently, we support only one
        // version, i.e. policy was filtered by system to contain only the version we
        // understand

        WSADPolicyUtil policyUtil = WSADPolicyUtil.getInstance(WSAD.WSAD10.Policy.PVN);
        
        Set<QName> understoodHeaders = new HashSet<QName>();

        if (privatePolicy.getMessagePolicy() != null) {
            EffectivePolicy ep = privatePolicy.getMessagePolicy();
            understoodHeaders.addAll(policyUtil.parseExpression(ep));
        }
        if (privatePolicy.getOperationPolicy() != null) {
            EffectivePolicy ep = privatePolicy.getOperationPolicy();
            understoodHeaders.addAll(policyUtil.parseExpression(ep));
        }
        if (privatePolicy.getEndpointPolicy() != null) {
            EffectivePolicy ep = privatePolicy.getEndpointPolicy();
            understoodHeaders.addAll(policyUtil.parseExpression(ep));
        }
        if (privatePolicy.getServicePolicy() != null) {
            EffectivePolicy ep = privatePolicy.getServicePolicy();
            understoodHeaders.addAll(policyUtil.parseExpression(ep));
        }
        
        WSAD.Policy wsad = new WSAD10.Policy(understoodHeaders);
        Set<WSSpecification.Policy> alternatives = new HashSet<WSSpecification.Policy>();
        alternatives.add(wsad);
        Map<String, WSSpecification> supportedVersions = new HashMap<String, WSSpecification>();
        supportedVersions.put(WSAD10.NAMESPACE_URI, new WSAD10(alternatives));

        return new WSADBindingModuleImpl((short)0, supportedVersions);
        
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.ws.appdata.WSAFeature$Provider#spi_createDefaultModules(java.lang.String,
     *      boolean)
     */
    @SuppressWarnings("unchecked")
    public ApplicationDataBindingModule.Provider spi_createDefaultBindingModule() throws FeatureException {

        // the specification versions supported are moot, i.e. when returing an
        // undeclared fault for my service, version used is version implied by
        // request. when processing an undeclared fault returned by partner
        // service, version used is implied by header infoset on response

        return new WSADBindingModuleImpl((short)0, Collections.EMPTY_MAP);

    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_getPolicyVocabularyNamespaces()
     */
    public Set<String> spi_getPolicyVocabularyNamespaces() {
        Set<String> pvns = new HashSet<String>();
        pvns.add(WSAD10.Policy.PVN);
        return pvns;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_isNative()
     */
    public boolean spi_isNative() {
        return true;
    }

}
