/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.mex.open;

import java.util.Collections;
import java.util.Set;

import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mex.WSMexFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mex.WSMexFeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mex.WSMexFeature.MetadataType;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;
import org.xml.sax.InputSource;

public final class WSMexFeatureImpl implements WSMexFeature.Provider {

    public static final String IMPL = WSMexFeatureImpl.class.getName();

    
    private static final long serialVersionUID = 1L;
    private static final Log log = SystemContext.getContext().getSystem().getLog(WSMexFeature.class);
    
    public WSMexFeatureImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getFeatureImpl()
     */
    public String spi_getFeatureImpl() {
        return IMPL;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_init(org.w3c.dom.Element)
     */
    public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {

        log.debug("init begin");

        // TODO: retrieve http server feature and register our servlet such
        // that we can process http get requests and init the servlet

        log.debug("init end");

    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_destroy()
     */
    public void spi_destroy() {
        log.debug("destroy begin");
        // TODO: destroy the servlet
        log.debug("destroy end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getConnectorRefs()
     */
    @SuppressWarnings("unchecked")
    public Set<String> spi_getConnectorRefs() {
        return Collections.EMPTY_SET;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.ws.mex.WSMexFeature.Provider#spi_getMetadata(org.bluestemsoftware.specification.eoa.ext.feature.ws.mex.WSMexFeature.MetadataType,
     *      java.lang.String)
     */
    public InputSource spi_getMetadata(MetadataType type, String location) throws WSMexFeatureException {

        // TODO: location should be mapped to a request type, e.g. ws-transfer, http-get, ...
        // within feature configuration. element should be cached. cache should be purgable via
        // a jmx enabled method.

        return null;
    }

}
