/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.mtom.soap;

import java.util.Map;

import org.bluestemsoftware.specification.eoa.component.binding.rt.BindingFaultRT;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageModule;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.ActionContext.MessageModules;
import org.bluestemsoftware.specification.eoa.component.message.rt.Content;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.soap.WSMTOMBindingModule;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule.WSSpecification;

public class WSMTOMBindingModuleImpl implements WSMTOMBindingModule.Provider {

    private short relativeOrder;
    private Map<String, WSSpecification> supportedVersions;

    public WSMTOMBindingModuleImpl(short relativeOrder, Map<String, WSSpecification> supportedVersions) {
        this.relativeOrder = relativeOrder;
        this.supportedVersions = supportedVersions;
    }

    public short spi_getRelativeOrder() {
        return relativeOrder;
    }

    public Map<String, WSSpecification> spi_getSupportedVersions() {
        return supportedVersions;
    }
    
    // note that all message processing methods are a no-op, i.e. the feature is
    // implemented by binding

    public MessageModule spi_handleMyServiceRequest(MessageModules requestModules, Content message) throws BindingFaultRT {
        return null;
    }

    public MessageModule spi_handleMyServiceResponse(MessageModules requestModules, Content message) throws BindingFaultRT {
        return null;
    }

    public MessageModule spi_handlePartnerServiceRequest(MessageModules requestModules, Content message) throws BindingFaultRT {
        return null;
    }

    public MessageModule spi_handlePartnerServiceResponse(MessageModules requestModules, MessageModules responseModules, Content message) throws BindingFaultRT {
        return null;
    }

    public void spi_setConsumer(Extension consumer) {
    }
}
