/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.mtom.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.bluestemsoftware.open.eoa.ext.feature.ws.mtom.soap.util.WSOMAPolicyUtil;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointOperationReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule.WSSpecification;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy;
import org.bluestemsoftware.specification.eoa.component.policy.rt.UnsupportedPolicyException;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.WSMTOM;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.WSMTOMFeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.WSMTOM.WSMTOM10;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.soap.WSMTOMBindingModule;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.soap.WSMTOMFeature;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;

public final class WSMTOMFeatureImpl implements WSMTOMFeature.Provider {

    public static final String IMPL = WSMTOMFeatureImpl.class.getName();

    private static final long serialVersionUID = 1L;

    private static final Log log = SystemContext.getContext().getSystem().getLog(WSMTOMFeature.class);

    public WSMTOMFeatureImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getExtensionImpl()
     */
    public String spi_getFeatureImpl() {
        return IMPL;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_getPolicyVocabularyNamespaces()
     */
    public Set<String> spi_getPolicyVocabularyNamespaces() {
        Set<String> pvns = new HashSet<String>();
        pvns.add(WSMTOM10.Policy.PVN);
        return pvns;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.TransportFeature$Provider#spi_destroyFeatureModule(org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule)
     */
    public void spi_destroyFeatureModule(FeatureModule featureModule) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_isNative()
     */
    public boolean spi_isNative() {
        return true;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_init(org.w3c.dom.Element)
     */
    public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {
        log.debug("init begin");
        log.debug("init end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_destroy()
     */
    public void spi_destroy() {
        log.debug("destroy begin");
        log.debug("destroy end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.ws.mtom.soap.WSMTOMFeature$Provider#spi_createBindingModule(org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference, org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy, org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy)
     */
    public WSMTOMBindingModule.Provider spi_createBindingModule(EndpointActionReference endpointActionReference, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws FeatureException, UnsupportedPolicyException {

        // we only are concerned about policy with policy subject endpoint. any other
        // subject is not supported. public endpoint policy is absolutely required

        if (publicPolicy.getEndpointPolicy() == null) {
            throw new UnsupportedPolicyException(publicPolicy.getMessagePolicy(),
                    "Public policy requires expression with ENDPOINT subject.");
        }

        if (privatePolicy.getMessagePolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getMessagePolicy(),
                    "Policy subject MESSAGE not supported");
        }
        if (privatePolicy.getOperationPolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getOperationPolicy(),
                    "Policy subject OPERATION not supported");
        }
        if (privatePolicy.getServicePolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getServicePolicy(),
                    "Policy subject SERVICE not supported");
        }

        if (publicPolicy.getMessagePolicy() != null) {
            throw new UnsupportedPolicyException(publicPolicy.getMessagePolicy(),
                    "Policy subject MESSAGE not supported");
        }
        if (publicPolicy.getOperationPolicy() != null) {
            throw new UnsupportedPolicyException(publicPolicy.getOperationPolicy(),
                    "Policy subject OPERATION not supported");
        }
        if (publicPolicy.getServicePolicy() != null) {
            throw new UnsupportedPolicyException(publicPolicy.getServicePolicy(),
                    "Policy subject SERVICE not supported");
        }

        EndpointOperationReference eor = (EndpointOperationReference)endpointActionReference.getParent();
        org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference epr = null;
        epr = (org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference)eor.getParent();
        ServiceReference serviceReference = (ServiceReference)epr.getParent();

        WSMTOMBindingModule.Provider wsMTOMModule = null;
        if (serviceReference.isMyService()) {
            wsMTOMModule = processMyEndpoint(epr, endpointActionReference, privatePolicy, publicPolicy);
        } else {
            wsMTOMModule = processPartnerEndpoint(epr, endpointActionReference, privatePolicy, publicPolicy);
        }

        return wsMTOMModule;

    }

    private WSMTOMBindingModule.Provider processMyEndpoint(EndpointReference epr, EndpointActionReference ear, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws WSMTOMFeatureException, UnsupportedPolicyException {

        if (privatePolicy.getEndpointPolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getEndpointPolicy(), "Private policy not allowed."
                    + " Private policy serves to clarify public policy defined on a 'partner' endpoint."
                    + " Referenced endpoint is 'my' endpoint.");
        }

        // the goal is to create one instance of ws-specification object for each supported
        // version of specification implied by policy. currently, we support only one
        // version, i.e. policy was filtered by system to contain only the version we
        // understand

        WSOMAPolicyUtil policyUtil = WSOMAPolicyUtil.getInstance(WSMTOM10.Policy.PVN);
        boolean mtomRequired = policyUtil.parseExpression(publicPolicy.getEndpointPolicy());

        if (mtomRequired) {
            log.debug("public policy indicates mtom is required");
        } else {
            log.debug("public policy indicates mtom is optional");
        }

        // policy util enforces that policy contains exactly one, non-emtpy alternative,
        // i.e. the returned ws policy set will always contain exactly one entry

        Set<WSSpecification.Policy> alternatives = new HashSet<WSSpecification.Policy>();
        alternatives.add(new WSMTOM10.Policy(mtomRequired));
        Map<String, WSSpecification> supportedVersions = new HashMap<String, WSSpecification>();
        supportedVersions.put(WSMTOM10.NAMESPACE_URI, new WSMTOM10(alternatives));

        return new WSMTOMBindingModuleImpl((short)0, supportedVersions);

    }

    private WSMTOMBindingModule.Provider processPartnerEndpoint(EndpointReference epr, EndpointActionReference ear, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws WSMTOMFeatureException, UnsupportedPolicyException {

        
        // the goal is to create one instance of ws-specification object for each supported
        // version of specification implied by policy. currently, we support only one
        // version, i.e. policy was filtered by system to contain only the version we
        // understand

        WSOMAPolicyUtil policyUtil = WSOMAPolicyUtil.getInstance(WSMTOM.WSMTOM10.Policy.PVN);
        boolean isRequired = policyUtil.parseExpression(publicPolicy.getEndpointPolicy());

        // if partner specificies no preference regarding requiredness, we use private
        // policy to clarify. note that neethi, as of this writing, does not support
        // policy intersection, which would preclude having to do this manually
        
        if (!isRequired) {

            log.debug("public policy defined on partner endpoint not specific regarding requiredness");
            
            // if private policy is undefined, or is non-specific, we leave the choice
            // up to binding at runtime, i.e. when serializing partner request

            if (privatePolicy.getEndpointPolicy() != null) {
                isRequired = policyUtil.parseExpression(privatePolicy.getEndpointPolicy());
                if (isRequired) {
                    log.debug("private policy clarifies mtom as required");
                } else {
                    log.debug("private policy not specific either.");
                }
            } else {
                log.debug("no private endpoint policy defined.");
            }

        } else {
            log.debug("public policy defined on partner endpoint requires mtom");
        }

        // policy util enforces that policy contains exactly one, non-emtpy alternative,
        // i.e. the returned ws policy set will always contain exactly one entry
        
        Set<WSSpecification.Policy> alternatives = new HashSet<WSSpecification.Policy>();
        alternatives.add(new WSMTOM10.Policy(isRequired));
        Map<String, WSSpecification> supportedVersions = new HashMap<String, WSSpecification>();
        supportedVersions.put(WSMTOM10.NAMESPACE_URI, new WSMTOM10(alternatives));
        
        return new WSMTOMBindingModuleImpl((short)0, supportedVersions);
        
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.ws.addressing.WSMTOMddressingFeature$Provider#spi_createDefaultModules(java.lang.String,
     *      boolean)
     */
    @SuppressWarnings("unchecked")
    public WSMTOMBindingModule.Provider spi_createDefaultBindingModule() throws FeatureException {
        
        // the specification versions supported are moot, i.e. when returing an
        // undeclared fault for my service, version used is version implied by
        // request. when processing an undeclared fault returned by partner
        // service, version used is implied by header infoset on response
        
        return new WSMTOMBindingModuleImpl((short)0, Collections.EMPTY_MAP);
        
    }

 


}
