/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces;

import java.io.StringWriter;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces.util.DOMSerializer;
import org.w3c.dom.DOMException;

public abstract class AbstractWSPolicyElement extends ElementNSImpl {

    public AbstractWSPolicyElement() {
        super();
    }

    public AbstractWSPolicyElement(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName)
            throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    /*
     * (non-Javadoc)
     * @see org.apache.xerces.dom.NodeImpl#toString()
     */
    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            DOMSerializer.serializeNode(this, writer, "UTF-8", true);
        } catch (Exception ex) {
            return super.toString();
        }
        return writer.toString();
    }

}
