/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces.util.Constants;

/**
 * 
 * Adapted from neethi XMLPrimitiveAssertion. Modified to hold a xerces element impl and will
 * eventually implement nested policy normalization.
 */
public class WSPolicyAssertionWrapper implements Assertion {

    private WSPolicyAssertionImpl underlying;
    
    public WSPolicyAssertionWrapper(WSPolicyAssertionImpl underlying) {
        this.underlying = underlying;
    }

    /**
     * Returns underlying element.
     * 
     * @return
     */
    public WSPolicyAssertionImpl getUnderlyingElement() {
        return underlying;
    }
    
    /*
     * (non-Javadoc)
     * @see org.apache.neethi.Assertion#getName()
     */
    public QName getName() {
        return underlying.getType();
    }

    /*
     * (non-Javadoc)
     * @see org.apache.neethi.Assertion#isOptional()
     */
    public boolean isOptional() {
        return Boolean.parseBoolean(underlying.getAttributeNS(Constants.WS_POLICY_NAMESPACE_URI, "Optional"));
    }

    /*
     * (non-Javadoc)
     * @see org.apache.neethi.Assertion#normalize()
     */
    public PolicyComponent normalize() {
        
        // TODO: implement nested policy expression normalization as required by
        // the ws-policy 1.5 spec

        if (isOptional()) {
            
            // if the optional attribute is set to true, then this is short hand for
            // a policy container which contains two alternatives, i.e. one empty and
            // one which contains this assertion

            Policy policy = new Policy();
            ExactlyOne exactlyOne = new ExactlyOne();

            All all = new All();
            WSPolicyAssertionImpl temp = (WSPolicyAssertionImpl)underlying.cloneNode(true);
            temp.removeAttributeNS(Constants.WS_POLICY_NAMESPACE_URI, "Optional");
            temp.setReadOnly(true, true);
            all.addPolicyComponent(new WSPolicyAssertionWrapper(temp));
            exactlyOne.addPolicyComponent(all);
            exactlyOne.addPolicyComponent(new All());
            policy.addPolicyComponent(exactlyOne);

            return policy;

        }
        
        return this;


    }

    /*
     * (non-Javadoc)
     * @see org.apache.neethi.Assertion#serialize(javax.xml.stream.XMLStreamWriter)
     */
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    /*
     * (non-Javadoc)
     * @see org.apache.neethi.PolicyComponent#equal(org.apache.neethi.PolicyComponent)
     */
    public boolean equal(PolicyComponent policyComponent) {
        if (policyComponent.getType() != org.apache.neethi.Constants.TYPE_ASSERTION) {
            return false;
        }
        return getName().equals(((Assertion) policyComponent).getName());
    }

    /*
     * (non-Javadoc)
     * @see org.apache.neethi.PolicyComponent#getType()
     */
    public short getType() {
        return org.apache.neethi.Constants.TYPE_ASSERTION;
    }

}
