/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces;

import org.apache.axiom.om.OMElement;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.xml.sax.EntityResolver;

/**
 * Overrides remote resolution behavior on neethi policy reference component. Our registry impl
 * performs the remote resolution when required.
 */
public class PolicyReferenceImpl extends PolicyReference {
    
    private EntityResolver entityResolver;
    
    public PolicyReferenceImpl(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public OMElement getRemoteReferedElement(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Policy getRemoteReferencedPolicy(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PolicyComponent normalize(PolicyRegistry reg, boolean deep) {
        return ((PolicyRegistryImpl)reg).lookup(entityResolver, getURI());
    }

}
