/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces.util;

import javax.xml.namespace.QName;

public interface Constants {

    public static final String ALL = "All";
    public static final String EXACTLY_ONE = "ExactlyOne";
    public static final String POLICY = "Policy";
    public static final String ID = "Id";
    public static final String LINE_BREAK = System.getProperty("line.separator");
    public static final String NAME = "Name";
    public static final String PREFIX = "wsp";
    public static final String WSU_NAMESPACE_PREFIX = "wsu";
    public static final String POLICY_REFERENCE = "PolicyReference";
    public static final String WS_POLICY_NAMESPACE_URI = "http://www.w3.org/ns/ws-policy";
    public static final String WS_POLICY_SCHEMA_LOCATION = "classpath:///schema/http.www.w3.org.ns.ws-policy.xsd";
    public static final String WSU_NAMESPACE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String STAX_INPUT_FACTORY = "com.ctc.wstx.stax.WstxInputFactory";
    public static final QName ID_QNAME = new QName(WSU_NAMESPACE_URI, ID);
    public static final QName NAME_QNAME = new QName("", NAME);
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    
    public static final String SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_LANGUAGE_PROPERTY = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String SCHEMA_LOCATION_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String GRAMMAR_POOL_PROPERTY = "http://apache.org/xml/properties/internal/grammar-pool";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String INCLUDE_IGNORABLE_WHITESPACE_FEATURE = "http://apache.org/xml/features/dom/include-ignorable-whitespace"; 
    public static final String SCHEMA_FULL_CHECKING_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DOCUMENT_CLASS_NAME_PROPERTY = "http://apache.org/xml/properties/dom/document-class-name";
    public static final String ENTITY_RESOLVER_PROPERTY = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String POLICY_DOCUMENT_CLASS_NAME = "org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces.WSPolicyDocumentImpl";
    
}
