/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces.WSPolicyAssertionWrapper;
import org.w3c.dom.Element;

public class PolicyFilter {
    
    public static Policy filter(Policy policy, Set<String> pvns) {

        policy = (Policy)policy.normalize(true);
        
        Policy filteredPolicy = new Policy();

        Iterator<?> itr = policy.getAttributes().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<?, ?> entry = (Map.Entry<?, ?>)itr.next();
            QName name = (QName)entry.getKey();
            if (name.equals(Constants.ID_QNAME)) {
                continue; // id is undefined for result
            }
            if (name.equals(Constants.NAME_QNAME)) {
                continue; // name is undefined for result
            }
            filteredPolicy.addAttribute((QName)entry.getKey(), (String)entry.getValue());
        }

        ExactlyOne filteredExactlyOne = new ExactlyOne();
        filteredPolicy.addPolicyComponent(filteredExactlyOne);

        // creates a set of unique alternatives. note that an empty
        // alternative is a valid entry, i.e. used to indicate
        // optionality - 'no behavior specified'
        
        Set<All> uniqueAlternatives = new HashSet<All>();

        ExactlyOne exactlyOne = (ExactlyOne)policy.getFirstPolicyComponent();
        itr = exactlyOne.getPolicyComponents().iterator();
        while (itr.hasNext()) {
            All alternative = (All)itr.next();
            All filteredAlternative = new All();
            Iterator<?> assItr = alternative.getAssertions().iterator();
            while (assItr.hasNext()) {
                Assertion assertion = (Assertion)assItr.next();
                String ns = assertion.getName().getNamespaceURI();
                if (ns != null && pvns.contains(ns)) {
                    filteredAlternative.addAssertion(assertion);
                }
            }
            boolean isUnique = true;
            for (All temp : uniqueAlternatives) {
                if (compareAlternatives(temp, filteredAlternative)) {
                    isUnique = false;
                    break;
                }
            }
            if (isUnique) {
                uniqueAlternatives.add(filteredAlternative);
                filteredExactlyOne.addPolicyComponent(filteredAlternative);
            }            
        }
        
        // if result contains no matching assertions, then we return
        // null, as required by spec
        
        if (uniqueAlternatives.size() == 1) {
            All all = uniqueAlternatives.iterator().next();
            if (all.getAssertions().size() == 0) {
                return null;
            }
        }
        
        return filteredPolicy; 

    }

    /*
     * equals method on XmlPrimitiveAssertion just compares qName, so we have to compare
     * ourself by comparing underlying element. our provider returns xerces element impl
     * which has a robust implementation of equals
     */
    private static boolean compareAlternatives(All alternative1, All alternative2) {
        Set<Element> set1 = new HashSet<Element>();
        Iterator<?> itr1 = alternative1.getPolicyComponents().iterator();
        while(itr1.hasNext()) {
            set1.add(((WSPolicyAssertionWrapper)itr1.next()).getUnderlyingElement());
        }
        Set<Element> set2 = new HashSet<Element>();
        Iterator<?> itr2 = alternative2.getPolicyComponents().iterator();
        while(itr2.hasNext()) {
            set2.add(((WSPolicyAssertionWrapper)itr2.next()).getUnderlyingElement());
        }
        return set1.equals(set2);
    }

}
