/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.policy.wsp15.xerces;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.component.policy.rt.PolicyExpression;
import org.bluestemsoftware.specification.eoa.ext.policy.wsp15.WSPolicyAssertion;

public class WSPolicyAssertionImpl extends AbstractWSPolicyElement implements WSPolicyAssertion {

    private static final long serialVersionUID = 1L;
    
    private Boolean isSupported;
    private QName qname;
    
    public WSPolicyAssertionImpl(WSPolicyDocumentImpl owner, String namespaceURI, String qualifiedName) {
        super(owner, namespaceURI, qualifiedName);
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.policy.rt.PolicyAssertion#isSupported()
     */
    public boolean isSupported() {
        return isSupported == null ? Boolean.FALSE : isSupported;
    }

    public void setIsSupported(boolean isSupported) {
        if (this.isSupported == null) {
            this.isSupported = Boolean.valueOf(isSupported);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.policy.rt.PolicyAssertion#getType()
     */
    public QName getType() {
        if (qname == null) {
            qname =  new QName(namespaceURI, localName);
        }
        return qname;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.policy.rt.PolicyAssertion#getNestedExpression()
     */
    public PolicyExpression getNestedExpression() {
        throw new UnsupportedOperationException("not yet implemented");
    }
  
}
