/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.rm.soap.util;

import org.bluestemsoftware.specification.eoa.component.policy.rt.EffectivePolicy;
import org.bluestemsoftware.specification.eoa.component.policy.rt.UnsupportedPolicyException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.WSRMFeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.WSRM.WSRM11;

public abstract class WSRMPPolicyUtil {
    
    public static WSRMPPolicyUtil getInstance(String policyVocabularyNamespace) {
        if (policyVocabularyNamespace.equals(WSRM11.Policy.PVN)) {
            return new WSRMP10PolicyUtil();
        }
        return null;
    }

    /**
     * Parses an expression which must be filtered to contain only one policy vocabulary, i.e. vocabulary
     * matching namespace used to retrieve policy util instance
     * 
     * @param effectivePolicy
     * @return
     * @throws WSRMFeatureException
     * @throws UnsupportedPolicyException
     */
    public abstract void parseExpression(EffectivePolicy effectivePolicy) throws WSRMFeatureException, UnsupportedPolicyException;

    public static class WSRMP10PolicyUtil extends WSRMPPolicyUtil {
        
        public void parseExpression(EffectivePolicy effectivePolicy) throws WSRMFeatureException, UnsupportedPolicyException {

           
        }

    }
}
