/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.rm.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.bluestemsoftware.open.eoa.ext.feature.ws.rm.soap.util.WSRMPPolicyUtil;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointOperationReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule.WSSpecification;
import org.bluestemsoftware.specification.eoa.component.intrface.InterfaceAction.Direction;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy;
import org.bluestemsoftware.specification.eoa.component.policy.rt.UnsupportedPolicyException;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.WSRM;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.WSRMFeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.WSRM.WSRM11;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.soap.WSRMBindingModule;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.rm.soap.WSRMFeature;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;

public final class WSRMFeatureImpl implements WSRMFeature.Provider {

    public static final String IMPL = WSRMFeatureImpl.class.getName();

    private static final long serialVersionUID = 1L;

    private static final Log log = SystemContext.getContext().getSystem().getLog(WSRMFeature.class);

    public WSRMFeatureImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getExtensionImpl()
     */
    public String spi_getFeatureImpl() {
        return IMPL;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_getPolicyVocabularyNamespaces()
     */
    public Set<String> spi_getPolicyVocabularyNamespaces() {
        Set<String> pvns = new HashSet<String>();
        pvns.add(WSRM11.Policy.PVN);
        return pvns;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_isNative()
     */
    public boolean spi_isNative() {
        return false;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.TransportFeature$Provider#spi_destroyFeatureModule(org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule)
     */
    public void spi_destroyFeatureModule(FeatureModule featureModule) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_init(org.w3c.dom.Element)
     */
    public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {
        log.debug("init begin");
        log.debug("init end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_destroy()
     */
    public void spi_destroy() {
        log.debug("destroy begin");
        log.debug("destroy end");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getConnectorRefs()
     */
    @SuppressWarnings("unchecked")
    public Set<String> spi_getConnectorRefs() {
        return Collections.EMPTY_SET;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.BindingFeature$Provider#spi_createBindingModule(org.bluestemsoftware.specification.eoa.component.engine.EndpointActionReference,
     *      org.bluestemsoftware.specification.eoa.component.policy.ActionPolicy,
     *      org.bluestemsoftware.specification.eoa.component.policy.ActionPolicy)
     */
    public WSRMBindingModule.Provider spi_createBindingModule(EndpointActionReference endpointActionReference, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws FeatureException, UnsupportedPolicyException {

        // we only are concerned about policy with policy subject endpoint. any other
        // subject is not supported. public endpoint policy is absolutely required

        if (publicPolicy.getEndpointPolicy() == null) {
            throw new UnsupportedPolicyException(publicPolicy.getMessagePolicy(),
                    "Public policy requires expression with ENDPOINT subject.");
        }

        if (privatePolicy.getMessagePolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getMessagePolicy(),
                    "Policy subject MESSAGE not supported");
        }
        if (privatePolicy.getOperationPolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getOperationPolicy(),
                    "Policy subject OPERATION not supported");
        }
        if (privatePolicy.getServicePolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getServicePolicy(),
                    "Policy subject SERVICE not supported");
        }

        if (publicPolicy.getMessagePolicy() != null) {
            throw new UnsupportedPolicyException(publicPolicy.getMessagePolicy(),
                    "Policy subject MESSAGE not supported");
        }
        if (publicPolicy.getOperationPolicy() != null) {
            throw new UnsupportedPolicyException(publicPolicy.getOperationPolicy(),
                    "Policy subject OPERATION not supported");
        }
        if (publicPolicy.getServicePolicy() != null) {
            throw new UnsupportedPolicyException(publicPolicy.getServicePolicy(),
                    "Policy subject SERVICE not supported");
        }

        EndpointOperationReference eor = (EndpointOperationReference)endpointActionReference.getParent();
        org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference epr = null;
        epr = (org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference)eor.getParent();
        ServiceReference serviceReference = (ServiceReference)epr.getParent();

        WSRMBindingModule.Provider wsRMModule = null;
        if (serviceReference.isMyService()) {
            wsRMModule = processMyEndpoint(epr, endpointActionReference, privatePolicy, publicPolicy);
        } else {
            wsRMModule = processPartnerEndpoint(epr, endpointActionReference, privatePolicy, publicPolicy);
        }

        return wsRMModule;

    }

    private WSRMBindingModule.Provider processMyEndpoint(EndpointReference epr, EndpointActionReference ear, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws WSRMFeatureException, UnsupportedPolicyException {

        if (privatePolicy.getEndpointPolicy() != null) {
            throw new UnsupportedPolicyException(privatePolicy.getEndpointPolicy(), "Private policy not allowed."
                    + " Private policy serves to clarify public policy defined on a 'partner' endpoint."
                    + " Referenced endpoint is 'my' endpoint.");
        }

        // the goal is to create one instance of ws-specification obj for each supported
        // version of specification implied by policy. currently, we support only one
        // version, i.e. policy was filtered by system to contain only the version we
        // understand

        WSRMPPolicyUtil policyUtil = WSRMPPolicyUtil.getInstance(WSRM.WSRM11.Policy.PVN);
        policyUtil.parseExpression(publicPolicy.getEndpointPolicy());
        
        Set<WSSpecification.Policy> alternatives = new HashSet<WSSpecification.Policy>();
        Map<String, WSSpecification> supportedVersions = new HashMap<String, WSSpecification>();
        supportedVersions.put(WSRM11.NAMESPACE_URI, new WSRM11(alternatives));
        
        short relativeOrder;
        if (ear.getReferencedComponent().getInterfaceAction().getDirection() == Direction.IN) {
            relativeOrder = Short.MAX_VALUE; // last in the chain of non-native modules
        } else {
            relativeOrder = Short.MIN_VALUE; // first in the chain of non-native modules
        }
        return new WSRMBindingModuleImpl(relativeOrder, supportedVersions);

    }

    private WSRMBindingModule.Provider processPartnerEndpoint(EndpointReference epr, EndpointActionReference ear, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws WSRMFeatureException, UnsupportedPolicyException {
        
        // the goal is to create one instance of ws-specification obj for each supported
        // version of specification implied by policy. currently, we support only one
        // version, i.e. policy was filtered by system to contain only the version we
        // understand

        WSRMPPolicyUtil policyUtil = WSRMPPolicyUtil.getInstance(WSRM.WSRM11.Policy.PVN);
        policyUtil.parseExpression(publicPolicy.getEndpointPolicy());
        
        Set<WSSpecification.Policy> alternatives = new HashSet<WSSpecification.Policy>();
        Map<String, WSSpecification> supportedVersions = new HashMap<String, WSSpecification>();
        supportedVersions.put(WSRM11.NAMESPACE_URI, new WSRM11(alternatives));
        
        short relativeOrder;
        if (ear.getReferencedComponent().getInterfaceAction().getDirection() == Direction.IN) {
            relativeOrder = Short.MIN_VALUE; // first in the chain of non-native modules
        } else {
            relativeOrder = Short.MAX_VALUE; // last in the chain of non-native modules
        }
        return new WSRMBindingModuleImpl(relativeOrder, supportedVersions);
        
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.ws.addressing.WSRMddressingFeature$Provider#spi_createDefaultModules(java.lang.String,
     *      boolean)
     */
    @SuppressWarnings("unchecked")
    public WSRMBindingModule.Provider spi_createDefaultBindingModule() throws FeatureException {
        
        // the specification versions supported are moot, i.e. when returing an
        // undeclared fault for my service, version used is version implied by
        // request. when processing an undeclared fault returned by partner
        // service, version used is implied by header infoset on response
        
        return new WSRMBindingModuleImpl(Short.MAX_VALUE, Collections.EMPTY_MAP);
        
    }

}
