/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.transport.http.util;

import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature.ServerAuthInfo;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.http.HTTPAuthenticationScheme;

public class ServerAuthInfoImpl implements ServerAuthInfo {

    private String realm;
    private HTTPAuthenticationScheme scheme;
    private boolean none;

    public ServerAuthInfoImpl() {
    }

    public ServerAuthInfoImpl(String realm, HTTPAuthenticationScheme scheme) {
        super();
        this.realm = realm;
        this.scheme = scheme;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature$ServerAuthInfo#getRealm()
     */
    public String getRealm() {
        return realm;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature$ServerAuthInfo#getScheme()
     */
    public HTTPAuthenticationScheme getScheme() {
        return scheme;
    }
    
    public void setNoAuthentication() {
        if (realm != null) {
            throw new IllegalArgumentException("Assertion 'none' was specified and yet a realm is defined.");
        }
        if (scheme != null) {
            throw new IllegalArgumentException("Assertion 'none' was specified and yet a scheme is defined.");
        }
        none = true;
    }
    
    public boolean noAuthentication() {
        return none;
    }

    public void setRealm(String realm) {
        if (realm == null) {
            return;
        }
        if (none) {
            throw new IllegalArgumentException("Error setting realm '"
                    + realm
                    + "'. Policy also defines assertion 'none' which implies no authentication.");
        }
        if (this.realm == null) {
            this.realm = realm;
        } else {
            if (!this.realm.equals(realm)) {
                throw new IllegalArgumentException("Error setting realm. Value '"
                        + realm
                        + "' differs from previously set value '"
                        + this.realm
                        + "'.");
            }
        }
    }

    public void setScheme(HTTPAuthenticationScheme scheme) {
        if (scheme == null) {
            return;
        }
        if (none) {
            throw new IllegalArgumentException("Error setting scheme '"
                    + scheme
                    + "'. Policy also defines assertion 'none' which implies no authentication.");
        }
        if (this.scheme == null) {
            this.scheme = scheme;
        } else {
            if (!this.scheme.equals(scheme)) {
                throw new IllegalArgumentException("Error setting scheme. Value '"
                        + scheme
                        + "' differs from previously set value '"
                        + this.scheme
                        + "'.");
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("realm: ");
        sb.append(realm);
        sb.append(System.getProperty("line.separator"));
        sb.append("scheme: ");
        sb.append(scheme);
        return sb.toString();
    }

}
