/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.transport.http;

import java.util.Map;

import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule.WSSpecification;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientRequest;
import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientResponse;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.rt.TransportFault;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.http.HTTPTransportModule;

/*
 * HTTP transport is configured at EndpointReference granularity. Feature modules are, however,
 * installed on an EndpointActionReference component. To account for this, we delegate calls
 * to HTTPTransport object which is mapped to EndpointReference component within http
 * transport feature.
 */
public class HTTPTransportModuleImpl implements HTTPTransportModule.Provider {

    HTTPTransport httpTransport;

    public HTTPTransportModuleImpl(HTTPTransport httpTransport) {
        this.httpTransport = httpTransport;
    }

    public HTTPClientResponse spi_doSend(HTTPClientRequest request, boolean handleRedirects) throws TransportFault {
        return httpTransport.spi_doSend(request, handleRedirects);
    }

    public void spi_setConsumer(Extension consumer) {
        httpTransport.spi_setConsumer(consumer);
    }

    public Map<String, WSSpecification> spi_getSupportedVersions() {
        return httpTransport.getSupportedVersions();
    }

}
