/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.transport.http.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.io.IOUtils;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerRequest;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;

public class HTTPServerRequestImpl implements HTTPServerRequest {

    private Log log = SystemContext.getContext().getSystem().getLog(HTTPServerRequest.class);

    private HttpServletRequest delegate;
    private String content;

    public HTTPServerRequestImpl(HttpServletRequest delegate) {
        this.delegate = delegate;
        if (log.isTraceEnabled()) {
            log.trace("method: " + delegate.getMethod());
            String requestURI = delegate.getRequestURI();
            String queryString = delegate.getQueryString();
            requestURI = queryString == null ? requestURI : requestURI + "?" + queryString;
            log.trace("uri: " + requestURI);
            Enumeration<?> names = delegate.getHeaderNames();
            if (names.hasMoreElements()) {
                log.trace("headers:");
                    while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = delegate.getHeader(name);
                    log.trace(name + ": " + value);
                }
            } else {
                log.trace("headers: none");
            }
            try {
                log.trace("content:");
                if (delegate.getContentLength() == 0) {
                    content = "";
                } else {
                    content = IOUtils.toString(delegate.getInputStream(), "UTF-8");
                }
                log.trace(content);
            } catch (IOException ie) {
                log.trace("unable to display");
            }
        }
    }

    public Object getAttribute(String name) {
        return delegate.getAttribute(name);
    }

    @SuppressWarnings("unchecked")
    public Enumeration<String> getAttributeNames() {
        return delegate.getAttributeNames();
    }

    public String getAuthType() {
        return delegate.getAuthType();
    }

    public String getCharacterEncoding() {
        return delegate.getCharacterEncoding();
    }

    public int getContentLength() {
        return delegate.getContentLength();
    }

    public String getContentType() {
        return delegate.getContentType();
    }

    public String getContextPath() {
        return delegate.getContextPath();
    }

    public long getDateHeader(String name) {
        return delegate.getDateHeader(name);
    }

    public String getHeader(String name) {
        return delegate.getHeader(name);
    }

    @SuppressWarnings("unchecked")
    public Enumeration<String> getHeaderNames() {
        return delegate.getHeaderNames();
    }

    @SuppressWarnings("unchecked")
    public Enumeration<String> getHeaders(String name) {
        return delegate.getHeaders(name);
    }

    public InputStream getInputStream() throws IOException {
        if (content == null) {
            if (delegate.getContentLength() == 0) {
                return new ByteArrayInputStream(new byte[] {});
            } else {
                return delegate.getInputStream();
            }
        } else {
            return new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
    }

    public int getIntHeader(String name) {
        return delegate.getIntHeader(name);
    }

    public String getLocalAddr() {
        return delegate.getLocalAddr();
    }

    public Locale getLocale() {
        return delegate.getLocale();
    }

    @SuppressWarnings("unchecked")
    public Enumeration<Locale> getLocales() {
        return delegate.getLocales();
    }

    public String getLocalName() {
        return delegate.getLocalName();
    }

    public int getLocalPort() {
        return delegate.getLocalPort();
    }

    public String getMethod() {
        return delegate.getMethod();
    }

    public String getParameter(String name) {
        return delegate.getParameter(name);
    }

    @SuppressWarnings("unchecked")
    public Map<String, String[]> getParameterMap() {
        return delegate.getParameterMap();
    }

    @SuppressWarnings("unchecked")
    public Enumeration<String> getParameterNames() {
        return delegate.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return delegate.getParameterValues(name);
    }

    public String getPathInfo() {
        return delegate.getPathInfo();
    }

    public String getPathTranslated() {
        return delegate.getPathTranslated();
    }

    public String getProtocol() {
        return delegate.getProtocol();
    }

    public String getQueryString() {
        return delegate.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        return delegate.getReader();
    }

    public String getRemoteAddr() {
        return delegate.getRemoteAddr();
    }

    public String getRemoteHost() {
        return delegate.getRemoteHost();
    }

    public int getRemotePort() {
        return delegate.getRemotePort();
    }

    public String getRemoteUser() {
        return delegate.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return delegate.getRequestedSessionId();
    }

    public String getRequestURI() {
        return delegate.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return delegate.getRequestURL();
    }

    public String getScheme() {
        return delegate.getScheme();
    }

    public String getServerName() {
        return delegate.getServerName();
    }

    public int getServerPort() {
        return delegate.getServerPort();
    }

    public String getServletPath() {
        return delegate.getServletPath();
    }

    public Principal getUserPrincipal() {
        return delegate.getUserPrincipal();
    }

    public boolean isSecure() {
        return delegate.isSecure();
    }

    public boolean isUserInRole(String role) {
        return delegate.isUserInRole(role);
    }

    public void removeAttribute(String name) {
        delegate.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        delegate.setAttribute(name, o);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        delegate.setCharacterEncoding(env);
    }

}
