/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.transport.vm;

import java.util.HashMap;
import java.util.Map;

import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.vm.VMTransportFeatureException;

public class VMTransport {

    private static Map<String, EndpointReference> eprs = new HashMap<String, EndpointReference>();

    private VMTransport() {
    }

    public static void addEndpointReference(String address, EndpointReference endpointReference) throws VMTransportFeatureException {

        // note no synchronization required, i.e. all writes occur during
        // start-up. all reads occur at runtime

        if (eprs.get(address) != null) {
            throw new VMTransportFeatureException("Error mapping address "
                    + address
                    + " to EPR "
                    + endpointReference.getFragmentIdentifier()
                    + ". Address already mapped to EPR "
                    + eprs.get(address).getFragmentIdentifier()
                    + ".");
        } else {
            eprs.put(address, endpointReference);
        }

    }

    public static EndpointReference getEndpointReference(String address) {

        // note no synchronization required, i.e. all writes occur during
        // start-up. all reads occur at runtime
        
        return eprs.get(address);

    }

}
