/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.ws.transport.vm;

import java.util.Collections;
import java.util.Map;

import org.bluestemsoftware.specification.eoa.component.binding.Binding;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule.WSSpecification;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.rt.TransportFault;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.vm.VMTransportModule;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.vm.VMTransportRequest;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.vm.rt.VMTransportProtocolRT;

public class VMTransportModuleImpl implements VMTransportModule.Provider {

    @SuppressWarnings("unchecked")
    public Map<String, WSSpecification> spi_getSupportedVersions() {
        return Collections.EMPTY_MAP;
    }

    public void spi_setConsumer(Extension consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.vm.VMTransportModule$Provider#spi_doSend(org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.vm.VMTransportRequest)
     */
    public void spi_doSend(VMTransportRequest request) throws TransportFault {
        EndpointReference epr = VMTransport.getEndpointReference(request.getAddress());
        if (epr == null) {
            throw new TransportFault(TransportFault.PROTOCOL_ERROR, "Address "
                    + request.getAddress()
                    + " is undefined within context of VM.");
        }
        Binding binding = epr.getEndpoint().getBindingReference().getReferencedComponent();
        VMTransportProtocolRT partner = (VMTransportProtocolRT)binding.getRuntimeProvider();
        partner.receiveAction(epr, request.getDirection(), request.getEnvelope());
    }
    
}
