/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.BindingOperationElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.BindingOperationFaultElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.BindingOperationInputElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.BindingOperationOutputElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAP11OperationElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAP12OperationElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAPOperationElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BindingOperationElementImpl extends AbstractWSDLElement implements BindingOperationElement {

    private static final long serialVersionUID = 1L;

    private SOAPOperationElement soapOperationElement;
    private BindingOperationInputElement inputElement;
    private BindingOperationOutputElement outputElement;
    private Map<String, BindingOperationFaultElement> faultElements = new HashMap<String, BindingOperationFaultElement>();

    public BindingOperationElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public BindingOperationElementImpl() {
        super();
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }

    public SOAPOperationElement setSOAPOperationElement(SOAPOperationElement soapOperationElement) {
        if (inputElement != null) {
            super.insertBefore(soapOperationElement, inputElement);
        } else if (outputElement != null) {
            super.insertBefore(soapOperationElement, outputElement);
        } else if (faultElements.size() > 0) {
            super.insertBefore(soapOperationElement, faultElements.values().iterator().next());
        } else {
            super.insertBefore(soapOperationElement, null);
        }
        this.soapOperationElement = soapOperationElement;
        return soapOperationElement;
    }

    public SOAPOperationElement getSOAPOperationElement() {
        return soapOperationElement;
    }

    public BindingOperationInputElement setInputElement(BindingOperationInputElement inputElement) {
        if (outputElement != null) {
            super.insertBefore(inputElement, outputElement);
        } else if (faultElements.size() > 0) {
            super.insertBefore(inputElement, faultElements.values().iterator().next());
        } else {
            super.insertBefore(inputElement, null);
        }
        this.inputElement = inputElement;
        return inputElement;
    }

    public BindingOperationInputElement getInputElement() {
        return inputElement;
    }

    public BindingOperationOutputElement setOutputElement(BindingOperationOutputElement outputElement) {
        if (faultElements.size() > 0) {
            super.insertBefore(outputElement, faultElements.values().iterator().next());
        } else {
            super.insertBefore(outputElement, null);
        }
        this.outputElement = outputElement;
        return outputElement;
    }

    public BindingOperationOutputElement getOutputElement() {
        return outputElement;
    }

    public BindingOperationFaultElement addFaultElement(BindingOperationFaultElement faultElement) {
        if (faultElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        super.insertBefore(faultElement, null);
        faultElements.put(faultElement.getName(), faultElement);
        return faultElement;
    }

    public Map<String, BindingOperationFaultElement> getFaultElements() {
        return faultElements;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11OperationElement.NAME)) {
                return setSOAPOperationElement((SOAPOperationElement)newChild);
            }
            if (elementName.equals(SOAP12OperationElement.NAME)) {
                return setSOAPOperationElement((SOAPOperationElement)newChild);
            }
            if (elementName.equals(BindingOperationInputElement.NAME)) {
                return setInputElement((BindingOperationInputElement)newChild);
            }
            if (elementName.equals(BindingOperationOutputElement.NAME)) {
                return setOutputElement((BindingOperationOutputElement)newChild);
            }
            if (elementName.equals(BindingOperationFaultElement.NAME)) {
                return addFaultElement((BindingOperationFaultElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11OperationElement.NAME)) {
                soapOperationElement = null;
            }
            if (elementName.equals(SOAP12OperationElement.NAME)) {
                soapOperationElement = null;
            }
            if (elementName.equals(BindingOperationInputElement.NAME)) {
                inputElement = null;
            }
            if (elementName.equals(BindingOperationOutputElement.NAME)) {
                outputElement = null;
            }
            if (elementName.equals(BindingOperationFaultElement.NAME)) {
                faultElements.remove(((Element)oldChild).getAttribute("name"));
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(BindingOperationInputElement.NAME)
                    || elementName.equals(BindingOperationOutputElement.NAME)
                    || elementName.equals(BindingOperationFaultElement.NAME)
                    || elementName.equals(SOAP11OperationElement.NAME)
                    || elementName.equals(SOAP12OperationElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(BindingOperationInputElement.NAME)
                    || elementName.equals(BindingOperationOutputElement.NAME)
                    || elementName.equals(BindingOperationFaultElement.NAME)
                    || elementName.equals(SOAP11OperationElement.NAME)
                    || elementName.equals(SOAP12OperationElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }
    
}
