/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces;

import java.io.StringWriter;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.util.Constants;
import org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.util.DOMSerializer;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.BindingOperationFaultElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAP11FaultElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAP12FaultElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAPFaultElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class BindingOperationFaultElementImpl extends AbstractWSDLElement implements BindingOperationFaultElement {

    private static final long serialVersionUID = 1L;
    
    private SOAPFaultElement soapFaultElement;

    public BindingOperationFaultElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public BindingOperationFaultElementImpl() {
        super();
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }
    
    public SOAPFaultElement setSOAPFaultElement(SOAPFaultElement soapFaultElement) {
        super.insertBefore(soapFaultElement, null);
        this.soapFaultElement = soapFaultElement;
        return soapFaultElement;
    }

    public SOAPFaultElement getSOAPFaultElement() {
        return soapFaultElement;
    }
    
    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11FaultElement.NAME)) {
                return setSOAPFaultElement((SOAPFaultElement)newChild);
            }
            if (elementName.equals(SOAP12FaultElement.NAME)) {
                return setSOAPFaultElement((SOAPFaultElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11FaultElement.NAME)) {
                soapFaultElement = null;
            }
            if (elementName.equals(SOAP12FaultElement.NAME)) {
                soapFaultElement = null;
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11FaultElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
            if (elementName.equals(SOAP12FaultElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }      
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11FaultElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
            if (elementName.equals(SOAP12FaultElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            DOMSerializer.serializeNode(this, writer, Constants.UTF_8, true);
        } catch (Exception ex) {
            return super.toString();
        }
        return writer.toString();
    }
    
}
