/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.BindingElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.DefinitionsElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ImportElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.MessageElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ServiceElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.TypesElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.ApplicationElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.EngineElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefinitionsElementImpl extends AbstractWSDLElement implements DefinitionsElement {

    private static final long serialVersionUID = 1L;
    private TypesElement typesElement;
    private Map<String, ImportElement> importElements = new LinkedHashMap<String, ImportElement>();
    private Map<String, MessageElement> messageElements = new LinkedHashMap<String, MessageElement>();
    private Map<String, PortTypeElement> portTypeElements = new LinkedHashMap<String, PortTypeElement>();
    private Map<String, BindingElement> bindingElements = new LinkedHashMap<String, BindingElement>();
    private Map<String, ServiceElement> serviceElements = new LinkedHashMap<String, ServiceElement>();
    private Map<String, ApplicationElement> applicationElements = new LinkedHashMap<String, ApplicationElement>();
    private Map<String, EngineElement> engineElements = new LinkedHashMap<String, EngineElement>();

    public DefinitionsElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public DefinitionsElementImpl() throws DOMException {
        super();
    }

    public void setTargetNamespace(String targetNamespace) {
        setAttribute("targetNamespace", targetNamespace);
    }

    public String getTargetNamespace() {
        return getAttribute("targetNamespace").equals("") ? null : getAttribute("targetNamespace");
    }

    public TypesElement getTypesElement() {
        return typesElement;
    }

    public ImportElement addImportElement(ImportElement importElement) {
        if (importElement.getNamespace() == null) {
            throw new IllegalArgumentException("Required attribute 'namespace' not set.");
        }
        if (messageElements.size() > 0) {
            super.insertBefore(importElement, messageElements.values().iterator().next());
        } else if (typesElement != null) {
            super.insertBefore(importElement, typesElement);
        } else if (portTypeElements.size() > 0) {
            super.insertBefore(importElement, portTypeElements.values().iterator().next());
        } else if (bindingElements.size() > 0) {
            super.insertBefore(importElement, bindingElements.values().iterator().next());
        } else if (serviceElements.size() > 0) {
            super.insertBefore(importElement, serviceElements.values().iterator().next());
        } else if (applicationElements.size() > 0) {
            super.insertBefore(importElement, applicationElements.values().iterator().next());
        } else if (engineElements.size() > 0) {
            super.insertBefore(importElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(importElement, null);
        }
        importElements.put(importElement.getNamespace(), importElement);
        return importElement;
    }

    public Map<String, ImportElement> getImportElements() {
        return importElements;
    }

    public TypesElement setTypesElement(TypesElement typesElement) {
        if (messageElements.size() > 0) {
            super.insertBefore(typesElement, messageElements.values().iterator().next());
        } else if (portTypeElements.size() > 0) {
            super.insertBefore(typesElement, portTypeElements.values().iterator().next());
        } else if (bindingElements.size() > 0) {
            super.insertBefore(typesElement, bindingElements.values().iterator().next());
        } else if (serviceElements.size() > 0) {
            super.insertBefore(typesElement, serviceElements.values().iterator().next());
        } else if (applicationElements.size() > 0) {
            super.insertBefore(typesElement, applicationElements.values().iterator().next());
        } else if (engineElements.size() > 0) {
            super.insertBefore(typesElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(typesElement, null);
        }
        this.typesElement = typesElement;
        return typesElement;
    }

    public MessageElement addMessageElement(MessageElement messageElement) {
        if (messageElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (portTypeElements.size() > 0) {
            super.insertBefore(messageElement, portTypeElements.values().iterator().next());
        } else if (bindingElements.size() > 0) {
            super.insertBefore(messageElement, bindingElements.values().iterator().next());
        } else if (serviceElements.size() > 0) {
            super.insertBefore(messageElement, serviceElements.values().iterator().next());
        } else if (applicationElements.size() > 0) {
            super.insertBefore(messageElement, applicationElements.values().iterator().next());
        } else if (engineElements.size() > 0) {
            super.insertBefore(messageElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(messageElement, null);
        }
        messageElements.put(messageElement.getName(), messageElement);
        return messageElement;
    }

    public Map<String, MessageElement> getMessageElements() {
        return messageElements;
    }

    public PortTypeElement addPortTypeElement(PortTypeElement portTypeElement) {
        if (portTypeElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (bindingElements.size() > 0) {
            super.insertBefore(portTypeElement, bindingElements.values().iterator().next());
        } else if (serviceElements.size() > 0) {
            super.insertBefore(portTypeElement, serviceElements.values().iterator().next());
        } else if (applicationElements.size() > 0) {
            super.insertBefore(portTypeElement, applicationElements.values().iterator().next());
        } else if (engineElements.size() > 0) {
            super.insertBefore(portTypeElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(portTypeElement, null);
        }
        portTypeElements.put(portTypeElement.getName(), portTypeElement);
        return portTypeElement;
    }

    public Map<String, PortTypeElement> getPortTypeElements() {
        return portTypeElements;
    }

    public BindingElement addBindingElement(BindingElement bindingElement) {
        if (bindingElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (serviceElements.size() > 0) {
            super.insertBefore(bindingElement, serviceElements.values().iterator().next());
        } else if (applicationElements.size() > 0) {
            super.insertBefore(bindingElement, applicationElements.values().iterator().next());
        } else if (engineElements.size() > 0) {
            super.insertBefore(bindingElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(bindingElement, null);
        }
        bindingElements.put(bindingElement.getName(), bindingElement);
        return bindingElement;
    }

    public Map<String, BindingElement> getBindingElements() {
        return bindingElements;
    }

    public ServiceElement addServiceElement(ServiceElement serviceElement) {
        if (serviceElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (applicationElements.size() > 0) {
            super.insertBefore(serviceElement, applicationElements.values().iterator().next());
        } else if (engineElements.size() > 0) {
            super.insertBefore(serviceElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(serviceElement, null);
        }
        serviceElements.put(serviceElement.getName(), serviceElement);
        return serviceElement;
    }

    public Map<String, ServiceElement> getServiceElements() {
        return serviceElements;
    }

    public ApplicationElement addApplicationElement(ApplicationElement applicationElement) {
        if (applicationElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (engineElements.size() > 0) {
            super.insertBefore(applicationElement, engineElements.values().iterator().next());
        } else {
            super.insertBefore(applicationElement, null);
        }
        applicationElements.put(applicationElement.getName(), applicationElement);
        return applicationElement;
    }

    public Map<String, ApplicationElement> getApplicationElements() {
        return applicationElements;
    }

    public EngineElement addEngineElement(EngineElement engineElement) {
        if (engineElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        super.insertBefore(engineElement, null);
        engineElements.put(engineElement.getName(), engineElement);
        return engineElement;
    }

    public Map<String, EngineElement> getEngineElements() {
        return engineElements;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ImportElement.NAME)) {
                return addImportElement((ImportElement)newChild);
            }
            if (elementName.equals(TypesElement.NAME)) {
                return setTypesElement((TypesElement)newChild);
            }
            if (elementName.equals(MessageElement.NAME)) {
                return addMessageElement((MessageElement)newChild);
            }
            if (elementName.equals(PortTypeElement.NAME)) {
                return addPortTypeElement((PortTypeElement)newChild);
            }
            if (elementName.equals(BindingElement.NAME)) {
                return addBindingElement((BindingElement)newChild);
            }
            if (elementName.equals(ServiceElement.NAME)) {
                return addServiceElement((ServiceElement)newChild);
            }
            if (elementName.equals(ApplicationElement.NAME)) {
                return addApplicationElement((ApplicationElement)newChild);
            }
            if (elementName.equals(EngineElement.NAME)) {
                return addEngineElement((EngineElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ImportElement.NAME)) {
                importElements.remove(((Element)oldChild).getAttribute("namespace"));
            }
            if (elementName.equals(TypesElement.NAME)) {
                typesElement = null;
            }
            if (elementName.equals(MessageElement.NAME)) {
                messageElements.remove(((Element)oldChild).getAttribute("name"));
            }
            if (elementName.equals(PortTypeElement.NAME)) {
                portTypeElements.remove(((Element)oldChild).getAttribute("name"));
            }
            if (elementName.equals(BindingElement.NAME)) {
                bindingElements.remove(((Element)oldChild).getAttribute("name"));
            }
            if (elementName.equals(ServiceElement.NAME)) {
                serviceElements.remove(((Element)oldChild).getAttribute("name"));
            }
            if (elementName.equals(ApplicationElement.NAME)) {
                applicationElements.remove(((Element)oldChild).getAttribute("name"));
            }
            if (elementName.equals(EngineElement.NAME)) {
                engineElements.remove(((Element)oldChild).getAttribute("name"));
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ImportElement.NAME)
                    || elementName.equals(TypesElement.NAME)
                    || elementName.equals(MessageElement.NAME)
                    || elementName.equals(PortTypeElement.NAME)
                    || elementName.equals(BindingElement.NAME)
                    || elementName.equals(ServiceElement.NAME)
                    || elementName.equals(ApplicationElement.NAME)
                    || elementName.equals(EngineElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ImportElement.NAME)
                    || elementName.equals(TypesElement.NAME)
                    || elementName.equals(MessageElement.NAME)
                    || elementName.equals(PortTypeElement.NAME)
                    || elementName.equals(BindingElement.NAME)
                    || elementName.equals(ServiceElement.NAME)
                    || elementName.equals(ApplicationElement.NAME)
                    || elementName.equals(EngineElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }

}
