/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeOperationElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class PortTypeElementImpl extends AbstractWSDLElement implements PortTypeElement {

    private static final long serialVersionUID = 1L;

    private boolean isRead;
    private Boolean isValid;
    private Map<String, PortTypeOperationElement> operationElements = new HashMap<String, PortTypeOperationElement>();

    public PortTypeElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public PortTypeElementImpl() {
        super();
    }
    
    public boolean isRead() {
        return isRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }
    
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
    
    public Boolean isValid() {
        return isValid;
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }
    
    public PortTypeOperationElement addOperationElement(PortTypeOperationElement operationElement) {
        if (operationElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        // because of the way we index ops, we must validate that name is unique now
        // rather than within profile validator
        if (operationElements.containsKey(operationElement.getName())) {
            throw new IllegalArgumentException("Duplicate operation "
                    + operationElement.getName()
                    + "'. A wsdl:portType in a DESCRIPTION MUST have operations"
                    + " with distinct values for their name attributes."
                    + " (R2304 ws-i basic profile 1.1)");
        }
        super.insertBefore(operationElement, null);
        operationElements.put(operationElement.getName(), operationElement);
        return operationElement;
    }

    public Map<String, PortTypeOperationElement> getOperationElements() {
        return operationElements;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationElement.NAME)) {
                return addOperationElement((PortTypeOperationElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationElement.NAME)) {
                operationElements.remove(((PortTypeOperationElement)oldChild).getName());
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }
    
}
