/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeOperationElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeOperationFaultElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeOperationInputElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeOperationOutputElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PortTypeOperationElementImpl extends AbstractWSDLElement implements PortTypeOperationElement {

    private static final long serialVersionUID = 1L;
    
    private Style style;
    private PortTypeOperationInputElement inputElement;
    private PortTypeOperationOutputElement outputElement;
    private Map<String, PortTypeOperationFaultElement> faultElements = new HashMap<String, PortTypeOperationFaultElement>();

    public PortTypeOperationElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public PortTypeOperationElementImpl() {
        super();
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }
    
    public Style getStyle() {
        return style;
    }

    public PortTypeOperationInputElement setInputElement(PortTypeOperationInputElement inputElement) {
        if (outputElement != null) {
            style = Style.SOLICIT_RESPONSE;
            super.insertBefore(inputElement, outputElement);
        } else if (faultElements.size() > 0) {
            super.insertBefore(inputElement, faultElements.values().iterator().next());
        } else {
            style = Style.ONE_WAY;
            super.insertBefore(inputElement, null);
        }
        this.inputElement = inputElement;
        return inputElement;
    }

    public PortTypeOperationInputElement getInputElement() {
        return inputElement;
    }

    public PortTypeOperationOutputElement setOutputElement(PortTypeOperationOutputElement outputElement) {
        if (inputElement != null) {
            style = Style.REQUEST_RESPONSE;
        } else {
            style = Style.NOTIFICATION;
        }
        if (faultElements.size() > 0) {
            super.insertBefore(outputElement, faultElements.values().iterator().next());
        } else {
            super.insertBefore(outputElement, null);
        }
        this.outputElement = outputElement;
        return outputElement;
    }

    public PortTypeOperationOutputElement getOutputElement() {
        return outputElement;
    }

    public PortTypeOperationFaultElement addFaultElement(PortTypeOperationFaultElement faultElement) {
        if (faultElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        super.insertBefore(faultElement, null);
        faultElements.put(faultElement.getName(), faultElement);
        return faultElement;
    }

    public Map<String, PortTypeOperationFaultElement> getFaultElements() {
        return faultElements;
    }
    
    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationInputElement.NAME)) {
                return setInputElement((PortTypeOperationInputElement)newChild);
            }
            if (elementName.equals(PortTypeOperationOutputElement.NAME)) {
                return setOutputElement((PortTypeOperationOutputElement)newChild);
            }
            if (elementName.equals(PortTypeOperationFaultElement.NAME)) {
                return addFaultElement((PortTypeOperationFaultElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationInputElement.NAME)) {
                inputElement = null;
            }
            if (elementName.equals(PortTypeOperationOutputElement.NAME)) {
                outputElement = null;
            }
            if (elementName.equals(PortTypeOperationFaultElement.NAME)) {
                faultElements.remove(((Element)oldChild).getAttribute("name"));
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationInputElement.NAME)
                    || elementName.equals(PortTypeOperationOutputElement.NAME) || elementName.equals(PortTypeOperationFaultElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(PortTypeOperationInputElement.NAME)
                    || elementName.equals(PortTypeOperationOutputElement.NAME) || elementName.equals(PortTypeOperationFaultElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }
    
}
