/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces;

import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.PortTypeOperationFaultElement;

public class PortTypeOperationFaultElementImpl extends AbstractWSDLElement implements PortTypeOperationFaultElement {

    private static final long serialVersionUID = 1L;

    public PortTypeOperationFaultElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public PortTypeOperationFaultElementImpl() {
        super();
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }
    
    public void setMessage(ComponentName value) {
        if (value == null) {
            return;
        }
        String prefix = ((WSDL11DocumentImpl)getOwnerDocument()).addNamespace(value.getNamespaceURI());
        setAttribute("message", prefix + ":" + value.getLocalPart());
    }

    public ComponentName getMessage() {
        String temp = getAttribute("message");
        if (temp.equals("")) {
            return null;
        }
        return ComponentName.valueOf(this, temp);
    }
    
}
