/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.ext;

import javax.xml.namespace.QName;

import org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.AbstractWSDLElement;
import org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.WSDL11DocumentImpl;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAP11HeaderElement;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAPHeaderElement;

public class SOAP11HeaderElementImpl extends AbstractWSDLElement implements SOAP11HeaderElement {

    private static final long serialVersionUID = 1L;

    public SOAP11HeaderElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public SOAP11HeaderElementImpl() {
        super();
    }

    public void setPart(String value) {
        setAttribute("part", value);
    }

    public String getPart() {
        return getAttribute("part").equals("") ? null : getAttribute("part");
    }
    
    public void setUse(String value) {
        setAttribute("use", value);
    }

    public String getUse() {
        return getAttribute("use").equals("") ? null : getAttribute("use");
    }
    
    public void setMessage(QName value) {
        if (value == null) {
            return;
        }
        String prefix = ((WSDL11DocumentImpl)getOwnerDocument()).addNamespace(value.getNamespaceURI());
        setAttribute("message", prefix + ":" + value.getLocalPart());
    }

    public QName getMessage() {
        String temp = getAttribute("message");
        if (temp.equals("")) {
            return null;
        }
        return ComponentName.valueOf(this, temp);
    }
    
    public void setNamespace(String value) {
        setAttribute("namespace", value);
    }

    public String getNamespace() {
        return getAttribute("namespace").equals("") ? null : getAttribute("namespace");
    }
    
    // *********************** Identity Methods ************************************

    
    @Override
    public final int hashCode() {
        return hashCode(getPart()) + hashCode(getMessage());
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (!(obj instanceof SOAPHeaderElement)) {
            return false;
        }

        if ((getPart() == ((SOAPHeaderElement)obj).getPart() || (getPart() != null && getPart()
                .equals(((SOAPHeaderElement)obj).getPart())))
                && (getMessage() == ((SOAPHeaderElement)obj).getMessage() || (getMessage() != null && getMessage()
                        .equals(((SOAPHeaderElement)obj).getMessage())))) {
            return true;
        }

        return false;
    }

    private int hashCode(Object object) {
        return (object == null ? 0 : object.hashCode());
    }

}
