/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.ext;

import org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.AbstractWSDLElement;
import org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.WSDL11DocumentImpl;
import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.ext.SOAP12OperationElement;

public class SOAP12OperationElementImpl extends AbstractWSDLElement implements SOAP12OperationElement {

    private static final long serialVersionUID = 1L;

    public SOAP12OperationElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public SOAP12OperationElementImpl() {
        super();
    }

    public void setStyle(String value) {
        setAttribute("style", value);
    }

    public String getStyle() {
        return getAttribute("style").equals("") ? null : getAttribute("style");
    }
    
    public String getSOAPAction() {
        return getAttribute("soapAction").equals("") ? null : getAttribute("soapAction");
    }
    
    public void setSOAPAction(String value) {
        setAttribute("soapAction", value);
    }

    public boolean isSOAPActionRequired() {
        String temp = getAttribute("soapActionRequired");
        if (temp.equals("")) {
            return true; // default value according to spec
        }
        return Boolean.parseBoolean(temp);
    }

    public void setIsSOAPActionRequired(boolean isRequired) {
        // leave unset, i.e. default is true
    }

}
