/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.util;

import org.bluestemsoftware.specification.eoa.ext.wsdl.wsdl11.WSDL11Factory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

/**
 * Provides information regarding context within which a document is being built.
 * 
 * @author wolfftw
 *
 */
public interface DocumentContext {

    /**
     * Gets entityResolver.
     * 
     * @return
     */
    public EntityResolver getEntityResolver();
    
    /**
     * Returns parent element of element currently being parsed. Provides contextual
     * information necessary for creating child elements .
     * 
     * @return parent element or null if fCurrentElement null or not an element node
     */
    public Element getParent();
    
    /**
     * Returns factory.
     * 
     * @return factory.
     */
    public WSDL11Factory getFactory();
    
}
