/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.wsdl.wsdl11.xerces.util;

import java.net.URI;

import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LSResourceResolverImpl implements LSResourceResolver {

    private EntityResolver entityResolver;
    private DOMImplementationLS domImplementation;

    public LSResourceResolverImpl(DOMImplementationLS domImplementation, EntityResolver entityResolver) {
        this.domImplementation = domImplementation;
        this.entityResolver = entityResolver;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicID, String systemID, String baseURI) {

        URI uri = null;
        InputSource is = null;

        try {
            uri = baseURI == null ? new URI(systemID) : new URI(baseURI).resolve(systemID);
            is = entityResolver.resolveEntity(publicID, uri.toString());
        } catch (Exception ex) {
            throw new LSException(LSException.PARSE_ERR, "Error resolving referenced schema at location "
                    + uri
                    + ". "
                    + ex);
        }

        LSInput lsInput = domImplementation.createLSInput();
        lsInput.setBaseURI(uri.toString());
        lsInput.setByteStream(is.getByteStream());
        lsInput.setCharacterStream(is.getCharacterStream());
        lsInput.setSystemId(is.getSystemId());
        lsInput.setPublicId(is.getPublicId());

        return lsInput;

    }

}
