/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.BindingOperationOutputElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11BodyElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11HeaderElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12BodyElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12HeaderElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAPBodyElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAPHeaderElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class BindingOperationOutputElementImpl extends AbstractWSDLElement implements BindingOperationOutputElement {

    private static final long serialVersionUID = 1L;

    private SOAPBodyElement soapBodyElement;
    private List<SOAPHeaderElement> soapHeaderElements = new ArrayList<SOAPHeaderElement>();

    public BindingOperationOutputElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public BindingOperationOutputElementImpl() {
        super();
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }

    public SOAPBodyElement setSOAPBodyElement(SOAPBodyElement soapBodyElement) {
        if (soapHeaderElements.size() > 0) {
            super.insertBefore(soapBodyElement, soapHeaderElements.get(0));
        } else {
            super.insertBefore(soapBodyElement, null);
        }
        this.soapBodyElement = soapBodyElement;
        return soapBodyElement;
    }

    public SOAPBodyElement getSOAPBodyElement() {
        return soapBodyElement;
    }

    public SOAPHeaderElement addSOAPHeaderElement(SOAPHeaderElement soapHeaderElement) {
        super.insertBefore(soapHeaderElement, null);
        soapHeaderElements.add(soapHeaderElement);
        return soapHeaderElement;
    }

    public List<SOAPHeaderElement> getSOAPHeaderElements() {
        return soapHeaderElements;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11BodyElement.NAME)) {
                return setSOAPBodyElement((SOAPBodyElement)newChild);
            }
            if (elementName.equals(SOAP11HeaderElement.NAME)) {
                return addSOAPHeaderElement((SOAPHeaderElement)newChild);
            }
            if (elementName.equals(SOAP12BodyElement.NAME)) {
                return setSOAPBodyElement((SOAPBodyElement)newChild);
            }
            if (elementName.equals(SOAP12HeaderElement.NAME)) {
                return addSOAPHeaderElement((SOAPHeaderElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11HeaderElement.NAME)) {
                soapHeaderElements.remove(((SOAPHeaderElement)oldChild));
            }
            if (elementName.equals(SOAP11BodyElement.NAME)) {
                soapBodyElement = null;
            }
            if (elementName.equals(SOAP12HeaderElement.NAME)) {
                soapHeaderElements.remove(((SOAPHeaderElement)oldChild));
            }
            if (elementName.equals(SOAP12BodyElement.NAME)) {
                soapBodyElement = null;
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11HeaderElement.NAME) || elementName.equals(SOAP11BodyElement.NAME) || elementName.equals(SOAP12HeaderElement.NAME) || elementName.equals(SOAP12BodyElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11HeaderElement.NAME) || elementName.equals(SOAP11BodyElement.NAME) || elementName.equals(SOAP12HeaderElement.NAME) || elementName.equals(SOAP12BodyElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }
    
}
