/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ServicePortElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11AddressElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12AddressElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAPAddressElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class ServicePortElementImpl extends AbstractWSDLElement implements ServicePortElement {

    private static final long serialVersionUID = 1L;

    private SOAPAddressElement soapAddressElement;

    public ServicePortElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public ServicePortElementImpl() {
        super();
    }

    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }

    public void setBinding(ComponentName value) {
        if (value == null) {
            return;
        }
        String prefix = ((WSDL11DocumentImpl)getOwnerDocument()).addNamespace(value.getNamespaceURI());
        setAttribute("binding", prefix + ":" + value.getLocalPart());
    }

    public ComponentName getBinding() {
        String temp = getAttribute("binding");
        if (temp.equals("")) {
            return null;
        }
        return ComponentName.valueOf(this, temp);
    }

    public SOAPAddressElement setSOAPAddressElement(SOAPAddressElement soapAddressElement) {
        super.insertBefore(soapAddressElement, null);
        this.soapAddressElement = soapAddressElement;
        return soapAddressElement;
    }

    public SOAPAddressElement getSOAPAddressElement() {
        return soapAddressElement;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11AddressElement.NAME)) {
                return setSOAPAddressElement((SOAP11AddressElement)newChild);
            }
            if (elementName.equals(SOAP12AddressElement.NAME)) {
                return setSOAPAddressElement((SOAP12AddressElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11AddressElement.NAME)) {
                soapAddressElement = null;
            }
            if (elementName.equals(SOAP12AddressElement.NAME)) {
                soapAddressElement = null;
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11AddressElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
            if (elementName.equals(SOAP12AddressElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(SOAP11AddressElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
            if (elementName.equals(SOAP12AddressElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }
    
}
