/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.util.Constants;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.util.DOMSerializer;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.util.WSDLParser;
import org.bluestemsoftware.specification.eoa.component.ComponentContext;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLException;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Factory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class WSDL11FactoryImpl implements WSDL11Factory.Provider {

    public static final String NAME = "wsdl-11-xerces";

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Factory$Provider#spi_createDocument(org.bluestemsoftware.specification.eoa.component.ComponentContext,
     *      javax.xml.transform.Source)
     */
    public WSDL11Document spi_createDocument(ComponentContext componentContext, Source source) throws WSDLException {

        if (source == null) {
            return new WSDL11DocumentImpl();
        }

        InputSource is = new InputSource();
        is.setSystemId(source.getSystemId());

        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            if (node == null) {
                throw new WSDLException("DOMSource must contain a node.");
            }
            StringWriter writer = new StringWriter();
            try {
                DOMSerializer.serializeNode(node, writer, Constants.UTF_8, false);
            } catch (Exception ex) {
                throw new WSDLException("Error serializing wsdl. " + ex);
            }
            is.setCharacterStream(new StringReader(writer.toString()));

        }

        if (source instanceof SAXSource) {
            if (((SAXSource)source).getInputSource() == null) {
                throw new WSDLException("SAXSource must contain an inputSource.");
            }
            is = ((SAXSource)source).getInputSource();
        }

        if (source instanceof StreamSource) {
            StreamSource streamSource = ((StreamSource)source);
            is.setByteStream(streamSource.getInputStream());
            is.setCharacterStream(streamSource.getReader());
            is.setPublicId(streamSource.getPublicId());
        }

        // parse the input source into a wsdl document which will serve as the
        // underlying service provider

        WSDL11DocumentImpl wsdlDocument = null;
        try {
            WSDLParser wsdlParser = new WSDLParser(componentContext);
            wsdlParser.parse(is);
            wsdlDocument = (WSDL11DocumentImpl)wsdlParser.getDocument();
        } catch (Exception ex) {
            throw new WSDLException("Error reading wsdl. " + ex);
        }

        return wsdlDocument;

    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Factory$Provider#spi_createDocument()
     */
    public WSDL11Document spi_createDocument() throws WSDLException {
        return new WSDL11DocumentImpl();
    }

}
