/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.AbstractWSDLElement;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.WSDL11DocumentImpl;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ApplicationElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.RoleElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class ApplicationElementImpl extends AbstractWSDLElement implements ApplicationElement {

    private static final long serialVersionUID = 1L;

    private boolean isRead;
    private Map<String, RoleElement> roleElements = new HashMap<String, RoleElement>();

    public ApplicationElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public ApplicationElementImpl() {
        super();
    }

    public boolean isRead() {
        return isRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ApplicationElement#setName(java.lang.String)
     */
    public void setName(String name) {
        setAttribute("name", name);
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ApplicationElement#getName()
     */
    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ApplicationElement#addRoleElement(org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.RoleElement)
     */
    public RoleElement addRoleElement(RoleElement roleElement) {
        if (roleElement.getName() == null) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        super.insertBefore(roleElement, null);
        roleElements.put(roleElement.getName(), roleElement);
        return roleElement;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ApplicationElement#getRoleElements()
     */
    public Map<String, RoleElement> getRoleElements() {
        return roleElements;
    }
    
    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(RoleElement.NAME)) {
                return addRoleElement((RoleElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }
    
    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(RoleElement.NAME)) {
                roleElements.remove(oldChild);
            }
        }
        return super.removeChild(oldChild);
    }
    
    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(RoleElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(RoleElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    
}
